/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.transform;

import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.phases.typing.resolver.transform.TransformParser;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class TransformParserTest {
    private TransformParser transformParser;
    private ComponentAst mockComponentAst;

    @Before
    public void setUp() {
        this.transformParser = new TransformParser();
        this.mockComponentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
    }

    @Test
    public void testParseWithNullParameters() {
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Either rightEither = Either.right((Object)componentAst);
        Mockito.when((Object)this.mockComponentAst.getParameter("Message", "setPayload")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.mockComponentAst.getParameter("Message", "setPayload").getValue()).thenReturn((Object)rightEither);
        Mockito.when((Object)this.mockComponentAst.getParameter("Message", "setAttributes")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.mockComponentAst.getParameter("Message", "setAttributes").getValue()).thenReturn((Object)rightEither);
        Mockito.when((Object)this.mockComponentAst.getParameter("Set Variables", "variables")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.mockComponentAst.getParameter("Set Variables", "variables").getValue()).thenReturn((Object)Either.right(Arrays.asList((ComponentAst)Mockito.mock(ComponentAst.class))));
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)componentAst.getParameter(Mockito.anyString(), (String)Mockito.eq((Object)"resource"))).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.right((Object)"string"));
        MuleEventExprBuilder result = this.transformParser.parse(this.mockComponentAst);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testParseWithNullParameters_Enable() {
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentAst innerComponentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Either rightEither = Either.right((Object)componentAst);
        Mockito.when((Object)this.mockComponentAst.getParameter("Message", "setPayload")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.mockComponentAst.getParameter("Message", "setPayload").getValue()).thenReturn((Object)rightEither);
        Mockito.when((Object)this.mockComponentAst.getParameter("Message", "setAttributes")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.mockComponentAst.getParameter("Message", "setAttributes").getValue()).thenReturn((Object)rightEither);
        Mockito.when((Object)this.mockComponentAst.getParameter("Set Variables", "variables")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.mockComponentAst.getParameter("Set Variables", "variables").getValue()).thenReturn((Object)Either.right(Arrays.asList(innerComponentModel)));
        Mockito.when((Object)componentAst.getParameter(Mockito.anyString(), (String)Mockito.eq((Object)"resource"))).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.right((Object)"string"));
        Mockito.when((Object)innerComponentModel.getIdentifier()).thenReturn((Object)TransformParser.SET_VARIABLE);
        Mockito.when((Object)innerComponentModel.getParameter("SetVariable", "variableName")).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)innerComponentModel.getParameter(Mockito.anyString(), (String)Mockito.eq((Object)"resource"))).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.right((Object)"abc"));
        Function<String, Optional> function = str -> {
            try {
                return Optional.of(new URI((String)str));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
        MuleEventExprBuilder result = this.transformParser.parse(this.mockComponentAst, function, (AstNotification)Mockito.mock(AstNotification.class), (AstNodeLocation)Mockito.mock(AstNodeLocation.class));
        Assert.assertNotNull((Object)result);
    }
}

