/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.StructuralNodeTypeResolver;
import org.mule.metadata.api.builder.AnyTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.ast.api.ComponentAst;

public class ScatterGatherTypeResolver
extends StructuralNodeTypeResolver {
    private static final String AGGREGATION_PARAMETER_GROUP = "Aggregation";
    private static final String COLLECT_LIST_PARAMETER = "collectList";

    private boolean isCollectList(MessageProcessorNode scatterGatherMessageProcessorNode) {
        ComponentAst scatterGatherComponentModel = scatterGatherMessageProcessorNode.getComponentModel();
        return scatterGatherComponentModel.getParameter(AGGREGATION_PARAMETER_GROUP, COLLECT_LIST_PARAMETER).getValue().isRight();
    }

    private CollectStrategy resolveCollectStrategy(MessageProcessorNode scatterGatherMessageProcessorNode) {
        return this.isCollectList(scatterGatherMessageProcessorNode) ? new ListCollectStrategy() : new MapCollectStrategy();
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        CollectStrategy collectStrategy = this.resolveCollectStrategy(messageProcessorNode);
        ArrayList<EventType> nestedEventTypes = new ArrayList<EventType>();
        messageProcessorNode.getMessageProcessorNodes().forEach(pipedMessageProcessorNode -> {
            EventType nestedEventType = typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, inputEventType, typingMuleAstVisitorContext);
            nestedEventTypes.add(nestedEventType);
            collectStrategy.processMessageProcessorOutput((MessageProcessorNode)pipedMessageProcessorNode, nestedEventType);
        });
        EventType outputEventType = TypeUtils.merge(TypeUtils.union(nestedEventTypes, typingMuleAstVisitorContext.getExpressionLanguageMetadataService()), collectStrategy.build());
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        return outputEventType;
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    protected boolean isSequential() {
        return false;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    protected boolean isScope() {
        return true;
    }

    public static class ListCollectStrategy
    extends BaseCollectStrategy {
        private final List<MessageMetadataTypeBuilder> messageMetadataTypeBuilders;

        public ListCollectStrategy() {
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = this.getMessageMetadataTypeBuilder();
            messageMetadataTypeBuilder.attributes().voidType();
            this.messageMetadataTypeBuilders = new ArrayList<MessageMetadataTypeBuilder>();
        }

        @Override
        public void processMessageProcessorOutput(MessageProcessorNode messageProcessorNode, EventType eventType) {
            MessageMetadataTypeBuilder routeMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
            MetadataType routePayloadMetadataType = (MetadataType)TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getPayloadType).orElse(TypesHelper.getTypeBuilder().anyType().build());
            routeMessageMetadataTypeBuilder.payload(routePayloadMetadataType);
            TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getAttributesType).ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)routeMessageMetadataTypeBuilder).attributes(arg_0));
            this.messageMetadataTypeBuilders.add(routeMessageMetadataTypeBuilder);
        }

        @Override
        protected void buildMessage() {
            AnyTypeBuilder elementTypeBuilder = null;
            if (this.messageMetadataTypeBuilders.isEmpty()) {
                elementTypeBuilder = TypesHelper.getTypeBuilder().anyType();
            } else if (this.messageMetadataTypeBuilders.size() == 1) {
                elementTypeBuilder = (TypeBuilder)this.messageMetadataTypeBuilders.get(0);
            } else {
                UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
                this.messageMetadataTypeBuilders.forEach(arg_0 -> ((UnionTypeBuilder)unionTypeBuilder).of(arg_0));
                elementTypeBuilder = unionTypeBuilder;
            }
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = this.getMessageMetadataTypeBuilder();
            messageMetadataTypeBuilder.payload().arrayType().of((TypeBuilder)Optional.ofNullable(elementTypeBuilder).orElse(TypesHelper.getTypeBuilder().anyType()));
        }
    }

    public static class MapCollectStrategy
    extends BaseCollectStrategy {
        private final ObjectTypeBuilder objectTypeBuilder;

        public MapCollectStrategy() {
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = this.getMessageMetadataTypeBuilder();
            this.objectTypeBuilder = messageMetadataTypeBuilder.payload().objectType();
            messageMetadataTypeBuilder.attributes().voidType();
        }

        @Override
        public void processMessageProcessorOutput(MessageProcessorNode messageProcessorNode, EventType eventType) {
            MessageMetadataTypeBuilder routeMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
            MetadataType routePayloadMetadataType = (MetadataType)TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getPayloadType).orElse(TypesHelper.getTypeBuilder().anyType().build());
            TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getAttributesType).ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)routeMessageMetadataTypeBuilder).attributes(arg_0));
            routeMessageMetadataTypeBuilder.payload(routePayloadMetadataType);
            ComponentLocation defaultComponentLocation = messageProcessorNode.getComponentModel().getLocation();
            LocationPart[] parts = defaultComponentLocation.getParts().toArray(new LocationPart[defaultComponentLocation.getParts().size()]);
            String routeId = this.buildRouteId(parts);
            this.objectTypeBuilder.addField().required().key(routeId).value((MetadataType)routeMessageMetadataTypeBuilder.build());
        }

        private String buildRouteId(LocationPart[] parts) {
            return parts[parts.length - 1].getPartPath();
        }
    }

    static interface CollectStrategy {
        public void processMessageProcessorOutput(MessageProcessorNode var1, EventType var2);

        public EventType build();
    }

    private static abstract class BaseCollectStrategy
    implements CollectStrategy {
        private final MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();

        protected MessageMetadataTypeBuilder getMessageMetadataTypeBuilder() {
            return this.messageMetadataTypeBuilder;
        }

        protected void buildMessage() {
        }

        @Override
        public EventType build() {
            this.buildMessage();
            return new EventType(TypeUtils.asVarDecls(this.messageMetadataTypeBuilder.build()));
        }
    }
}

