/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.BaseExtensionAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;

@RunWith(value=JUnit4.class)
public class BaseExtensionAnnotatorTest {
    private BaseExtensionAnnotator annotator;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private AnnotatingMuleAstVisitorContext context;
    @Mock
    private DataSenseProviderResolver dataSenseProviderResolver;
    @Mock
    private ComponentAst componentAst;
    @Mock
    private ComponentModel componentModel;
    @Mock
    private OperationCallBuilder operationCallBuilder;
    @Mock
    private HasOutputModel hasOutputModel;
    @Mock
    private OutputModel outputModel;
    @Mock
    private OutputModel outputAttributesModel;
    @Mock
    private ParameterModel parameterModel;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.annotator = new BaseExtensionAnnotator(){

            protected Optional<ComponentModel> resolveComponentModel(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext context, DataSenseProviderResolver resolver, ComponentAst componentModels) {
                return Optional.of(BaseExtensionAnnotatorTest.this.componentModel);
            }
        };
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentAst);
        Mockito.when((Object)this.context.getDataSenseProviderResolver()).thenReturn((Object)this.dataSenseProviderResolver);
        Mockito.when((Object)this.context.getAnnotation((Class)Mockito.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.getName()).thenReturn((Object)"TestComponent");
        Mockito.when((Object)this.componentModel.getAllParameterModels()).thenReturn(Collections.singletonList(this.parameterModel));
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"testParam");
        Mockito.when((Object)this.parameterModel.hasDynamicType()).thenReturn((Object)false);
        OperationCallBuilderAnnotation annotationMock = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)annotationMock);
        Mockito.when((Object)annotationMock.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)this.hasOutputModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.hasOutputModel.getOutputAttributes()).thenReturn((Object)this.outputAttributesModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn(null);
        Mockito.when((Object)this.outputAttributesModel.getType()).thenReturn(null);
    }

    @Test
    public void testAnnotate_SuccessfulAnnotation() {
        this.annotator.annotate(this.messageProcessorNode, this.context);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.operationCallBuilder});
    }

    @Test
    public void testAnnotate_HandlesHasOutputModel() {
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.operationCallBuilder});
    }

    @Test
    public void testAnnotate_AddsHasDynamicMetadataAnnotation() {
        Mockito.when((Object)this.parameterModel.hasDynamicType()).thenReturn((Object)true);
        Mockito.when((Object)this.outputModel.hasDynamicType()).thenReturn((Object)true);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.operationCallBuilder});
    }

    @Test
    public void testAnnotateWithNoDynamicType() {
        final ImmutableSourceModel immutableSourceModel = (ImmutableSourceModel)Mockito.mock(ImmutableSourceModel.class);
        BaseExtensionAnnotator testAnnotator = new BaseExtensionAnnotator(){

            protected Optional<ComponentModel> resolveComponentModel(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext context, DataSenseProviderResolver resolver, ComponentAst componentModels) {
                return Optional.of(immutableSourceModel);
            }
        };
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"test");
        Mockito.when((Object)parameterModel.hasDynamicType()).thenReturn((Object)false);
        Mockito.when((Object)immutableSourceModel.getAllParameterModels()).thenReturn(Arrays.asList(parameterModel));
        Mockito.when((Object)this.context.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of((MuleFlowAnnotation)Mockito.mock(MuleFlowAnnotation.class)));
        Mockito.when((Object)immutableSourceModel.getOutput()).thenReturn((Object)((OutputModel)Mockito.mock(OutputModel.class)));
        Mockito.when((Object)immutableSourceModel.getOutputAttributes()).thenReturn((Object)((OutputModel)Mockito.mock(OutputModel.class)));
        OperationCallBuilderAnnotation operationCallBuilderAnnotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        Mockito.when((Object)operationCallBuilderAnnotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)operationCallBuilderAnnotation);
        Mockito.when((Object)this.context.logger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        testAnnotator.annotate(this.messageProcessorNode, this.context);
        Assert.assertNotNull((Object)this.context);
    }
}

