/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.BaseAstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleFlowNode
extends BaseAstNode {
    private final MessageProcessorNode rootMessageProcessorNode;
    private final ComponentAst componentModel;
    private AstNode parentAstNode;
    private final Map<ComponentLocation, MessageProcessorNode> messageProcessorNodeMap;

    public MuleFlowNode(ComponentIdentifier componentIdentifier, ComponentAst componentModel, MessageProcessorNode rootMessageProcessorNode) {
        super(componentIdentifier);
        this.componentModel = componentModel;
        Preconditions.checkNotNull((Object)componentModel);
        this.setName(componentModel.getComponentId().orElse(null));
        this.rootMessageProcessorNode = rootMessageProcessorNode;
        this.messageProcessorNodeMap = new HashMap<ComponentLocation, MessageProcessorNode>();
    }

    public MuleFlowNode(ComponentIdentifier componentIdentifier, ComponentAst componentModel) {
        this(componentIdentifier, componentModel, null);
    }

    public AstNode getParentAstNode() {
        return this.parentAstNode;
    }

    public ComponentAst getComponentModel() {
        return this.componentModel;
    }

    public void setParentAstNode(AstNode parentAstNode) {
        this.parentAstNode = parentAstNode;
    }

    public Optional<MessageProcessorNode> getRootMessageProcessorNode() {
        return Optional.ofNullable(this.rootMessageProcessorNode);
    }

    @Override
    public <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context) {
        return astNodeVisitor.visit(this, context);
    }

    public void register(ComponentLocation componentLocation, MessageProcessorNode messageProcessorNode) {
        Preconditions.checkState((!this.findMessageProcessorNode(componentLocation.getLocation()).isPresent() ? 1 : 0) != 0, (Object)String.format("Node already registered for componentLocation %s", componentLocation.getLocation()));
        this.messageProcessorNodeMap.put(componentLocation, messageProcessorNode);
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(String location) {
        return this.messageProcessorNodeMap.entrySet().stream().filter(messageProcessorNode -> ((ComponentLocation)messageProcessorNode.getKey()).getLocation().equals(location)).map(Map.Entry::getValue).findFirst();
    }

    public Stream<MessageProcessorNode> findMessageProcessorNodes(boolean includeRoot) {
        return this.messageProcessorNodeMap.values().stream().filter(messageProcessorNode -> includeRoot || !messageProcessorNode.isRootMessageProcessorNode());
    }

    public Stream<MessageProcessorNode> findMessageProcessorNodes() {
        return this.findMessageProcessorNodes(false);
    }
}

