/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.phases.builder.ConfigResolutionScopeStrategy;
import org.mule.datasenseapi.api.ConfigResolutionScope;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigResolutionScopeStrategyTest {
    @Mock
    private ComponentAst mockComponent;
    @Mock
    private ComponentLocation mockLocation;

    @Test
    public void testMatchReturnsFalseWhenNoFileName() {
        Mockito.when((Object)this.mockComponent.getLocation()).thenReturn((Object)this.mockLocation);
        Mockito.when((Object)this.mockLocation.getFileName()).thenReturn(Optional.empty());
        ConfigResolutionScope scope = new ConfigResolutionScope("test-config.xml");
        ConfigResolutionScopeStrategy strategy = new ConfigResolutionScopeStrategy(scope);
        Assert.assertFalse((boolean)strategy.match(this.mockComponent));
    }

    @Test
    public void testMatchReturnsFalseWhenFileNameDoesNotMatch() {
        Mockito.when((Object)this.mockComponent.getLocation()).thenReturn((Object)this.mockLocation);
        Mockito.when((Object)this.mockLocation.getFileName()).thenReturn(Optional.of("other-config.xml"));
        ConfigResolutionScope scope = new ConfigResolutionScope("test-config.xml");
        ConfigResolutionScopeStrategy strategy = new ConfigResolutionScopeStrategy(scope);
        Assert.assertFalse((boolean)strategy.match(this.mockComponent));
    }

    @Test
    public void testMatchReturnsTrueWhenFileNameMatches() {
        Mockito.when((Object)this.mockComponent.getLocation()).thenReturn((Object)this.mockLocation);
        Mockito.when((Object)this.mockLocation.getFileName()).thenReturn(Optional.of("test-config.xml"));
        ConfigResolutionScope scope = new ConfigResolutionScope("test-config.xml");
        ConfigResolutionScopeStrategy strategy = new ConfigResolutionScopeStrategy(scope);
        Assert.assertTrue((boolean)strategy.match(this.mockComponent));
    }
}

