package org.mule.datasense.enrichment.model;

import org.mule.runtime.ast.api.ComponentAst;

import com.google.common.base.Preconditions;

public class PathComponentModelSelector implements ComponentModelSelector {

  final static String PREFIX = "@";

  private final String location;

  public PathComponentModelSelector(String location) {
    Preconditions.checkNotNull(location);
    this.location = location;
  }

  @Override
  public boolean match(ComponentAst componentModel) {
    return location.equals(getLocation(componentModel));
  }

  public static String getLocation(ComponentAst componentModel) {
    return componentModel.getLocation().getLocation();
  }
}
