package org.mule.datasense.catalog.model.resolver.loaders;

import com.google.common.base.Preconditions;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.dw.DwBasedShapeTypeLoader;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import java.io.File;

public class FromDwShapeTypeLoaderFactory implements ShapeTypeLoaderFactory {

  private MetadataFormat format;
  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

  public FromDwShapeTypeLoaderFactory(MetadataFormat format,
                                      ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    Preconditions.checkNotNull(format);
    this.format = format;
  }

  @Override
  public String getTypeFormat() {
    return format.getId();
  }

  @Override
  public String getLoaderFormat() {
    return MetadataFormats.DW.getId();
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new DwBasedShapeTypeLoader(file, expressionLanguageMetadataService) {

      @Override
      protected MetadataFormat getMetadataFormat() {
        return format;
      }
    };
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new DwBasedShapeTypeLoader(content, expressionLanguageMetadataService) {

      @Override
      protected MetadataFormat getMetadataFormat() {
        return format;
      }
    };
  }
}
