package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.flatfile.FlatfileTypeLoader;

import java.io.File;

public class FlatFileTypeLoaderFactory implements ShapeTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormats.FLAT_FILE.getId();
  }

  @Override
  public String getLoaderFormat() {
    return MetadataFormats.FLAT_FILE.getId();
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new FlatfileTypeLoader(file.getPath());
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    throw new UnsupportedOperationException();
  }
}
