package org.mule.datasense.catalog.model.resolver;

import com.google.common.base.Preconditions;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

public class SingleTypeResolver implements TypeResolver {

  private final String format;
  private String typeIdentifier;
  private TypeResolver shapeTypeResolver;
  private TypeResolver exampleTypeResolver;

  public SingleTypeResolver(String typeIdentifier, String format, ShapeTypeResolver shapeTypeResolver,
                            ExampleTypeResolver exampleTypeResolver) {
    Preconditions.checkNotNull(typeIdentifier);
    Preconditions.checkNotNull(format);
    this.typeIdentifier = typeIdentifier;
    this.format = format;
    this.shapeTypeResolver = shapeTypeResolver;
    this.exampleTypeResolver = exampleTypeResolver;
  }

  private TypeResolver getTypeResolver() {
    return shapeTypeResolver != null ? shapeTypeResolver : exampleTypeResolver;
  }

  @Override
  public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
    if (!this.typeIdentifier.equals(typeIdentifier)) {
      return Optional.empty();
    }

    return Optional.of(getTypeResolver().resolveType(typeIdentifier)
        .orElseThrow(() -> new TypeResolverException("Failed to resolve type " + typeIdentifier)));
  }
}
