/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.common.loader.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.common.loader.json.JsonMatcher;
import org.mule.datasense.common.loader.json.JsonMatcherStrategy;

class JsonObjectStrategy
implements JsonMatcherStrategy {
    private JsonObject jsonObject;

    public JsonObjectStrategy(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public Optional<JsonMatcher> match(String name) {
        return JsonMatcher.createMatcher(this.jsonObject.get(name));
    }

    @Override
    public Optional<Stream<JsonMatcher>> matchMany(String name) {
        JsonElement jsonElement = this.jsonObject.get(name);
        if (jsonElement instanceof JsonArray) {
            return Optional.of(JsonMatcher.jsonArrayStream((JsonArray)jsonElement).map(jsonElement1 -> JsonMatcher.createRequiredMatcher(jsonElement1)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Stream<JsonMatcher>> matchMany() {
        throw new IllegalStateException();
    }

    @Override
    public Optional<JsonPrimitive> matchAttribute(String name) {
        JsonElement jsonElement = this.jsonObject.get(name);
        if (jsonElement == null) {
            return Optional.empty();
        }
        if (jsonElement instanceof JsonPrimitive) {
            return Optional.of((JsonPrimitive)jsonElement);
        }
        throw new IllegalStateException();
    }

    @Override
    public JsonElement element() {
        return this.jsonObject;
    }
}

