package org.mule.datasense.enrichment.loader.json;

import com.google.gson.JsonElement;
import org.mule.datasense.common.loader.json.JsonMatcher;
import org.mule.datasense.enrichment.loader.ComponentModelEnrichmentLoader;
import org.mule.datasense.enrichment.loader.ComponentModelEnrichmentLoaderContext;
import org.mule.datasense.enrichment.model.ComponentModelEnrichment;
import org.mule.datasense.enrichment.model.ComponentModelEnrichments;
import org.mule.datasense.enrichment.model.ComponentModelSelector;
import org.mule.datasense.enrichment.model.ComponentModelSelectors;

import java.util.Optional;

public class ComponentModelEnrichmentJsonLoader extends ComponentModelEnrichmentLoader<JsonElement> {

  @Override
  public void load(ComponentModelEnrichments componentModelEnrichments, JsonElement object,
                   ComponentModelEnrichmentLoaderContext componentModelEnrichmentLoaderContext) {
    JsonMatcher.createMatcher(object).ifPresent(jsonMatcher -> {
      jsonMatcher.matchMany("enrichments").ifPresent(enrichments -> {
        enrichments.forEach(enrichment -> {
          final String select = enrichment.requireString("select");
          enrichment.match("value").ifPresent(value -> {
            final ComponentModelSelector componentModelSelector =
                ComponentModelSelectors.create(select);
            componentModelEnrichments.add(new ComponentModelEnrichment(componentModelSelector, value.element()));
          });
        });
      });
    });
  }

  @Override
  public Optional<ComponentModelEnrichments> load(JsonElement element,
                                                  ComponentModelEnrichmentLoaderContext componentModelEnrichmentLoaderContext) {
    final ComponentModelEnrichments componentModelEnrichments = new ComponentModelEnrichments();
    load(componentModelEnrichments, element, componentModelEnrichmentLoaderContext);
    return Optional.of(componentModelEnrichments);
  }
}
