package org.mule.datasense.declarations.loader;

import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.common.util.Notifier;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Optional;

public class TypeDeclarationLoaderContext {

  private final ComponentAst componentModel;
  private final TypesCatalog typesCatalog;
  private final Notifier notifier;

  public TypeDeclarationLoaderContext(ComponentAst componentModel, TypesCatalog typesCatalog) {
    this(componentModel, typesCatalog, null);
  }

  public TypeDeclarationLoaderContext(ComponentAst componentModel, TypesCatalog typesCatalog, Notifier notifier) {
    this.componentModel = componentModel;
    this.typesCatalog = typesCatalog;
    this.notifier = notifier;
  }

  public TypesCatalog getTypesCatalog() {
    return typesCatalog;
  }

  public Optional<Notifier> getNotifier() {
    return Optional.ofNullable(notifier);
  }

  public ComponentAst getComponentModel() {
    return componentModel;
  }
}
