package org.mule.datasense.declarations.loader;

import static java.util.Optional.ofNullable;

import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.datasense.common.util.TypeUtils;
import org.mule.datasense.declarations.loader.xml.TypeDeclarationXmlLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Optional;

import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTypeDeclarationLoader<T, U> implements TypeDeclarationXmlLoader<T, U> {

  @Override
  public abstract Optional<T> load(U object, TypeDeclarationLoaderContext typeDeclarationLoaderContext);

  protected MetadataType resolveType(String typeExpression, TypesCatalog typesCatalog) throws TypeResolverException {
    MetadataType result = null;
    String currentTypeExpression = typeExpression;
    boolean useArray = false;
    if (currentTypeExpression.endsWith("[]")) {
      useArray = true;
      currentTypeExpression = StringUtils.removeEnd(currentTypeExpression, "[]");
    }
    String typeIdentifier = currentTypeExpression;
    result = typesCatalog.resolveType(typeIdentifier).orElseThrow(() -> new TypeResolverException(String
        .format(
                "Failed to resolve type %s in expression %s.",
                typeIdentifier,
                typeExpression)));
    if (useArray) {
      final BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder(MetadataFormat.JAVA);
      result = typeBuilder.arrayType().of(result).build();
    }
    return result;
  }

  protected ComponentLocation findComponentLocation(TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
    return ofNullable(typeDeclarationLoaderContext.getComponentModel())
        .map(ComponentAst::getLocation).orElse(null);
  }

}
