package org.mule.datasense.common.util;

import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;

public interface Notifier {

  default void reportWarning(ComponentLocation componentLocation, I18nMessage i18nMessage) {
    reportWarning(i18nMessage);
  }

  void reportWarning(I18nMessage i18nMessage);

  default void reportError(ComponentLocation componentLocation, I18nMessage i18nMessage) {
    reportError(i18nMessage);
  }

  void reportError(I18nMessage i18nMessage);

  default void reportFatalError(ComponentLocation componentLocation, I18nMessage i18nMessage) {
    reportFatalError(i18nMessage);
  }

  void reportFatalError(I18nMessage i18nMessage);
}
