package org.mule.datasense.common.loader.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

import java.util.Optional;
import java.util.stream.Stream;

class JsonArrayStrategy implements JsonMatcherStrategy {

  private JsonArray jsonArray;

  public JsonArrayStrategy(JsonArray jsonArray) {
    this.jsonArray = jsonArray;
  }

  @Override
  public Optional<JsonMatcher> match(String name) {
    throw new IllegalStateException();
  }

  @Override
  public Optional<Stream<JsonMatcher>> matchMany(String name) {
    throw new IllegalStateException();
  }

  @Override
  public Optional<Stream<JsonMatcher>> matchMany() {
    return Optional
        .of(JsonMatcher.jsonArrayStream(jsonArray).map(jsonElement1 -> JsonMatcher.createRequiredMatcher(jsonElement1)));
  }

  @Override
  public Optional<JsonPrimitive> matchAttribute(String name) {
    throw new IllegalStateException();
  }

  @Override
  public JsonElement element() {
    return jsonArray;
  }
}
