package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;

import java.io.File;

public class XmlSchemaTypeLoaderFactory implements ShapeTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormat.XML.getId();
  }

  @Override
  public String getLoaderFormat() {
    return "xml-schema";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    final SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(file);
    return new XmlTypeLoader(schemaCollector);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    final SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema("", content);
    return new XmlTypeLoader(schemaCollector);
  }
}
