package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.map.MapTypeLoader;

import java.io.File;

public class MapTypeLoaderFactory implements ShapeTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormat.JAVA.getId();
  }

  @Override
  public String getLoaderFormat() {
    return "raml";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new MapTypeLoader(file);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new MapTypeLoader(content);
  }

}
