package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.json.api.JsonExampleTypeLoader;

import java.io.File;

public class JsonTypeLoaderFactory implements ExampleTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormat.JSON.getId();
  }

  @Override
  public String getLoaderFormat() {
    return "json";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new JsonExampleTypeLoader(file);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new JsonExampleTypeLoader(content);
  }
}
