package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.java.api.JavaTypeLoader;

import java.io.File;

public class JavaTypeLoaderFactory implements ShapeTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormat.JAVA.getId();
  }

  @Override
  public String getLoaderFormat() {
    return "java";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new JavaTypeLoader(Thread.currentThread().getContextClassLoader());
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new JavaTypeLoader(Thread.currentThread().getContextClassLoader());
  }
}
