package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.csv.CsvExampleTypeLoader;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import java.io.File;

public class CsvExampleTypeLoaderFactory implements ExampleTypeLoaderFactory {

  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

  public CsvExampleTypeLoaderFactory(
                                     ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
  }

  @Override
  public String getTypeFormat() {
    return MetadataFormat.CSV.getId();
  }

  @Override
  public String getLoaderFormat() {
    return MetadataFormat.CSV.getId();
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new CsvExampleTypeLoader(file, expressionLanguageMetadataService);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    if (content != null) {
      content = content.trim();
    }
    return new CsvExampleTypeLoader(content, expressionLanguageMetadataService);
  }
}
