package org.mule.datasense.catalog.builder;

import org.mule.datasense.catalog.model.resolver.ExampleTypeLoaderRegistry;
import org.mule.datasense.catalog.model.resolver.ShapeTypeLoaderRegistry;
import org.mule.datasense.common.util.Notifier;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import java.util.Optional;

public class TypesCatalogBuilderContext {

  private final Notifier notifier;
  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
  private final ShapeTypeLoaderRegistry shapeTypeLoaderRegistry;
  private final ExampleTypeLoaderRegistry exampleTypeLoaderRegistry;

  public TypesCatalogBuilderContext(Notifier notifier,
                                    ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    this.notifier = notifier;
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    shapeTypeLoaderRegistry = new ShapeTypeLoaderRegistry(expressionLanguageMetadataService);
    exampleTypeLoaderRegistry = new ExampleTypeLoaderRegistry(expressionLanguageMetadataService);
  }

  public TypesCatalogBuilderContext(
                                    ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    this(null, expressionLanguageMetadataService);
  }

  public Optional<Notifier> getNotifier() {
    return Optional.ofNullable(notifier);
  }

  public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
    return expressionLanguageMetadataService;
  }

  public ShapeTypeLoaderRegistry getShapeTypeLoaderRegistry() {
    return shapeTypeLoaderRegistry;
  }

  public ExampleTypeLoaderRegistry getExampleTypeLoaderRegistry() {
    return exampleTypeLoaderRegistry;
  }
}
