/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.enrichment;

import java.io.File;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.datasense.declarations.loader.xml.ExtensionOperationTypeDeclarationXmlLoader;
import org.mule.datasense.declarations.loader.xml.MessageProcessorTypeDeclarationXmlLoader;
import org.mule.datasense.declarations.model.ExtensionOperationTypeDeclaration;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.datasense.enrichment.BaseTypeDeclarationsTest;
import org.mule.metadata.api.model.MetadataType;

public class TypeDeclarationsXmlTest
extends BaseTypeDeclarationsTest {
    @Test
    public void resolutionOfoperationTypeDeclaration() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-002");
        BaseTypeDeclarationsTest.MyNotifier myNotifier = new BaseTypeDeclarationsTest.MyNotifier();
        BaseTypeDeclarationsTest.TypeDeclarationsHelper typeDeclarationsHelper = this.createTypeDeclarationsHelper(new File(testFolder, "app.xml"), Collections.singletonList(new File(testFolder, "app-types.xml")), myNotifier, new ExtensionOperationTypeDeclarationXmlLoader());
        Assert.assertEquals((Object)"%type _:Java = () -> @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n  \"payload\" : @typeAlias(\"value\" : \"Type1\") {\n    \"number\"? : Number, \n    \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n    \"street_name\"? : String\n  }, \n  \"attributes\" : @typeAlias(\"value\" : \"Type1\") {\n    \"number\"? : Number, \n    \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n    \"street_name\"? : String\n  }\n}", (Object)this.toString((MetadataType)((ExtensionOperationTypeDeclaration)typeDeclarationsHelper.findTypeDeclaration("mp1")).getFunctionType()));
        Assert.assertEquals((Object)"%type _:Java = (p1:@typeAlias(\"value\" : \"Type1\") {\n  \"number\"? : Number, \n  \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n  \"street_name\"? : String\n},p2:@typeAlias(\"value\" : \"Type1\") {\n  \"number\"? : Number, \n  \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n  \"street_name\"? : String\n}) -> void", (Object)this.toString((MetadataType)((ExtensionOperationTypeDeclaration)typeDeclarationsHelper.findTypeDeclaration("mp2")).getFunctionType()));
    }

    @Test
    @Ignore
    public void resolutionOfmessageProcessorTypeDeclaration() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-002");
        BaseTypeDeclarationsTest.MyNotifier myNotifier = new BaseTypeDeclarationsTest.MyNotifier();
        BaseTypeDeclarationsTest.TypeDeclarationsHelper typeDeclarationsHelper = this.createTypeDeclarationsHelper(new File(testFolder, "app.xml"), Collections.singletonList(new File(testFolder, "app-types.xml")), myNotifier, new MessageProcessorTypeDeclarationXmlLoader());
        Assert.assertEquals((Object)"%type _:Java = (input:{\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : @typeAlias(\"value\" : \"Type1\") {\n      \"number\"? : Number, \n      \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n      \"street_name\"? : String\n    }, \n    \"attributes\" : @typeAlias(\"value\" : \"Type1\") {\n      \"number\"? : Number, \n      \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n      \"street_name\"? : String\n    }\n  }, \n  \"variables\" : {\n    \"var1\" : @label(\"value\" : \"Example Schema\") @typeAlias(\"value\" : \"Type2\") {\n      \"firstName\" : String, \n      \"lastName\" : String, \n      \"age\"? : @range(\"from\" : 0) @int Number, \n      * : Any\n    }\n  }\n}) -> {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : @typeAlias(\"value\" : \"Type1\") {\n      \"number\"? : Number, \n      \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n      \"street_name\"? : String\n    }, \n    \"attributes\" : @typeAlias(\"value\" : \"Type1\") {\n      \"number\"? : Number, \n      \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n      \"street_name\"? : String\n    }\n  }, \n  \"variables\" : {\n    \"var1\" : @label(\"value\" : \"Example Schema\") @typeAlias(\"value\" : \"Type2\") {\n      \"firstName\" : String, \n      \"lastName\" : String, \n      \"age\"? : @range(\"from\" : 0) @int Number, \n      * : Any\n    }\n  }\n}", (Object)this.toString((MetadataType)((MessageProcessorTypeDeclaration)typeDeclarationsHelper.findTypeDeclaration("mp3")).getFunctionType()));
    }

    @Test
    public void resolutionOfmessageProcessorTypeDeclarationWithFailedToResolveVariableType() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-002");
        BaseTypeDeclarationsTest.MyNotifier myNotifier = new BaseTypeDeclarationsTest.MyNotifier();
        BaseTypeDeclarationsTest.TypeDeclarationsHelper typeDeclarationsHelper = this.createTypeDeclarationsHelper(new File(testFolder, "app.xml"), Collections.singletonList(new File(testFolder, "app-types.xml")), myNotifier, new MessageProcessorTypeDeclarationXmlLoader());
        Assert.assertEquals((Object)"%type _:Java = () -> {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", (Object)this.toString((MetadataType)((MessageProcessorTypeDeclaration)typeDeclarationsHelper.findTypeDeclaration("mp4")).getFunctionType()));
        Assert.assertTrue((boolean)myNotifier.getMessages().contains("[ERROR] Failed to resolve variable var1 type expression 'XmlExampleWithoutElement' on element 'logger' custom metadata. It will be skipped from definition. Original error was: Failed to resolve type XmlExampleWithoutElement."));
    }

    @Test
    public void resolutionOfmessageProcessorTypeDeclarationWithXmlShapeVariableType() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-002");
        BaseTypeDeclarationsTest.MyNotifier myNotifier = new BaseTypeDeclarationsTest.MyNotifier();
        BaseTypeDeclarationsTest.TypeDeclarationsHelper typeDeclarationsHelper = this.createTypeDeclarationsHelper(new File(testFolder, "app.xml"), Collections.singletonList(new File(testFolder, "app-types.xml")), myNotifier, new MessageProcessorTypeDeclarationXmlLoader());
        MessageProcessorTypeDeclaration messageProcessorTypeDeclaration = (MessageProcessorTypeDeclaration)typeDeclarationsHelper.findTypeDeclaration("mp5");
        Assert.assertEquals((Object)"%type _:Java = () -> {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"var0\" : @typeId(\"value\" : \"#root:{http://uri}Root0\") @typeAlias(\"value\" : \"XmlShapeWithElemWithNs0\") {\n      \"{http://uri}Root0\" : @typeId(\"value\" : \"{http://uri}#AnonType_Root0\") @description(\"lang\" : \"en\", \"value\" : \"A user with all the information\") {{\n        \"{http://uri}name\" : String, \n        \"{http://uri}lastName\" : String, \n        \"{http://uri}male\" : Boolean, \n        \"{http://uri}age\" : Number\n      }}\n    }, \n    \"var1\" : @typeId(\"value\" : \"#root:{http://uri}Root1\") @typeAlias(\"value\" : \"XmlShapeWithElemWithNs1\") {\n      \"{http://uri}Root1\" : @typeId(\"value\" : \"{http://uri}#AnonType_Root1\") @description(\"lang\" : \"en\", \"value\" : \"A user with all the information\") {{\n        \"{http://uri}name\" : String, \n        \"{http://uri}lastName\" : String, \n        \"{http://uri}male\" : Boolean, \n        \"{http://uri}age\" : Number\n      }}\n    }\n  }\n}", (Object)this.toString((MetadataType)messageProcessorTypeDeclaration.getFunctionType()));
    }

    @Test
    public void resolutionOfmessageProcessorTypeDeclarationWithArray() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-002");
        BaseTypeDeclarationsTest.MyNotifier myNotifier = new BaseTypeDeclarationsTest.MyNotifier();
        BaseTypeDeclarationsTest.TypeDeclarationsHelper typeDeclarationsHelper = this.createTypeDeclarationsHelper(new File(testFolder, "app.xml"), Collections.singletonList(new File(testFolder, "app-types.xml")), myNotifier, new MessageProcessorTypeDeclarationXmlLoader());
        MessageProcessorTypeDeclaration messageProcessorTypeDeclaration = (MessageProcessorTypeDeclaration)typeDeclarationsHelper.findTypeDeclaration("mp6");
        Assert.assertEquals((Object)"%type _:Java = (input:{\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : [@typeAlias(\"value\" : \"Type1\") {\n        \"number\"? : Number, \n        \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n        \"street_name\"? : String\n      }], \n    \"attributes\" : [@typeAlias(\"value\" : \"Type1\") {\n        \"number\"? : Number, \n        \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \n        \"street_name\"? : String\n      }]\n  }, \n  \"variables\" : {\n\n  }\n}) -> void", (Object)this.toString((MetadataType)messageProcessorTypeDeclaration.getFunctionType()));
    }
}

