/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.loader;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.catalog.builder.TypesCatalogBuilder;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.loader.BaseTypesCatalogLoader;
import org.mule.datasense.catalog.loader.TypesCatalogLoaderContext;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.common.util.Notifier;
import org.mule.datasense.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.runtime.api.i18n.I18nMessage;

public class BaseTypesCatalogLoaderTest {
    private Notifier createTestNotifier() {
        return new Notifier(){

            public void reportWarning(I18nMessage i18nMessage) {
            }

            public void reportError(I18nMessage i18nMessage) {
            }

            public void reportFatalError(I18nMessage i18nMessage) {
            }
        };
    }

    private TypesCatalogBuilderContext createTypesCatalogBuilderContext() {
        return new TypesCatalogBuilderContext(this.createTestNotifier(), ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService());
    }

    @Test
    public void testLoadFiles() throws Exception {
        TestTypesCatalogLoader loader = new TestTypesCatalogLoader();
        TypesCatalogBuilderContext builderContext = this.createTypesCatalogBuilderContext();
        List<File> testFiles = Arrays.asList(new File("test1.txt"), new File("test2.txt"));
        TypesCatalog result = loader.loadFiles(testFiles, builderContext);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)loader.isLoadFilesCalled());
        Assert.assertEquals(testFiles, loader.getFilesReceived());
        Assert.assertNotNull((Object)loader.getContextReceived());
    }

    @Test
    public void testLoadData() throws Exception {
        TestTypesCatalogLoader loader = new TestTypesCatalogLoader();
        TypesCatalogBuilderContext builderContext = this.createTypesCatalogBuilderContext();
        List<String> testData = Arrays.asList("data1", "data2");
        URI testUri = new URI("file:///test");
        TypesCatalog result = loader.loadData(testData, builderContext, testUri);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)loader.isLoadDataCalled());
        Assert.assertEquals(testData, loader.getDataReceived());
        Assert.assertNotNull((Object)loader.getContextReceived());
    }

    @Test
    public void testBaseUriSetting() throws Exception {
        final boolean[] uriWasPassedToBuilder = new boolean[1];
        URI testUri = new URI("file:///test");
        BaseTypesCatalogLoader loader = new BaseTypesCatalogLoader(){

            protected void loadFiles(List<File> files, TypesCatalogLoaderContext typesCatalogLoaderContext) {
            }

            protected void loadData(List<String> data, TypesCatalogLoaderContext typesCatalogLoaderContext) {
                uriWasPassedToBuilder[0] = true;
            }
        };
        loader.loadData(new ArrayList(), this.createTypesCatalogBuilderContext(), testUri);
        Assert.assertTrue((String)"URI should have been passed to the TypesCatalogBuilder", (boolean)uriWasPassedToBuilder[0]);
    }

    private static class TestTypesCatalogLoader
    extends BaseTypesCatalogLoader {
        private boolean loadFilesCalled;
        private boolean loadDataCalled;
        private List<File> filesReceived;
        private List<String> dataReceived;
        private TypesCatalogLoaderContext contextReceived;

        private TestTypesCatalogLoader() {
        }

        protected void loadFiles(List<File> files, TypesCatalogLoaderContext typesCatalogLoaderContext) {
            this.loadFilesCalled = true;
            this.filesReceived = files;
            this.contextReceived = typesCatalogLoaderContext;
        }

        protected void loadData(List<String> data, TypesCatalogLoaderContext typesCatalogLoaderContext) {
            this.loadDataCalled = true;
            this.dataReceived = data;
            this.contextReceived = typesCatalogLoaderContext;
        }

        public boolean isLoadFilesCalled() {
            return this.loadFilesCalled;
        }

        public boolean isLoadDataCalled() {
            return this.loadDataCalled;
        }

        public List<File> getFilesReceived() {
            return this.filesReceived;
        }

        public List<String> getDataReceived() {
            return this.dataReceived;
        }

        public TypesCatalogLoaderContext getContextReceived() {
            return this.contextReceived;
        }
    }

    private static class TestTypesCatalogBuilder
    extends TypesCatalogBuilder {
        private URI baseUri;

        public TestTypesCatalogBuilder(TypesCatalogBuilderContext typesCatalogBuilderContext) {
            super(typesCatalogBuilderContext);
        }

        public TypesCatalogBuilder baseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public TypesCatalog build() {
            return new StubTypesCatalog();
        }
    }

    private static class StubTypesCatalog
    extends TypesCatalog {
        public StubTypesCatalog() {
            super(Collections.emptyList());
        }
    }
}

