/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.model.resolver.loaders;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.catalog.model.resolver.loaders.CopybookTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderRegistry;
import org.mule.metadata.MetadataFormats;

public class TypeLoaderRegistryTest {
    private TestTypeLoaderRegistry typeLoaderRegistry;
    private TypeLoaderFactory mockTypeLoaderFactory;

    public void setUp() {
        this.mockTypeLoaderFactory = new CopybookTypeLoaderFactory();
        this.typeLoaderRegistry = new TestTypeLoaderRegistry(TypeLoaderFactory.class);
    }

    @Test
    public void testRegister() {
        this.setUp();
        this.typeLoaderRegistry.register(this.mockTypeLoaderFactory);
        Optional result = this.typeLoaderRegistry.getFactory(MetadataFormats.COPYBOOK.getId(), MetadataFormats.COPYBOOK.getId());
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.mockTypeLoaderFactory, result.get());
    }

    @Test
    public void testGetFactoryWhenFactoryExists() {
        this.setUp();
        this.typeLoaderRegistry.register(this.mockTypeLoaderFactory);
        Optional result = this.typeLoaderRegistry.getFactory(MetadataFormats.COPYBOOK.getId(), MetadataFormats.COPYBOOK.getId());
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.mockTypeLoaderFactory, result.get());
    }

    @Test
    public void testGetName() {
        this.setUp();
        Assert.assertEquals((Object)"TestTypeLoaderRegistry", (Object)this.typeLoaderRegistry.getName());
    }

    private static class TestTypeLoaderRegistry
    extends TypeLoaderRegistry {
        public TestTypeLoaderRegistry(Class<? extends TypeLoaderFactory> serviceClass) {
            super(serviceClass);
        }

        public String getName() {
            return "TestTypeLoaderRegistry";
        }
    }
}

