/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.model.resolver.loaders;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderFactory;

public abstract class TypeLoaderRegistry {
    private final Map<TypeLoaderRegistryKey, TypeLoaderFactory> typeLoaderFactoryMap = new HashMap<TypeLoaderRegistryKey, TypeLoaderFactory>();

    public TypeLoaderRegistry(Class<? extends TypeLoaderFactory> serviceClass) {
        ImmutableList.copyOf(ServiceLoader.load(serviceClass, Thread.currentThread().getContextClassLoader()).iterator()).forEach(this::register);
    }

    public void register(TypeLoaderFactory typeLoaderFactory) {
        this.typeLoaderFactoryMap.put(new TypeLoaderRegistryKey(typeLoaderFactory.getTypeFormat(), typeLoaderFactory.getLoaderFormat()), typeLoaderFactory);
    }

    public Optional<TypeLoaderFactory> getFactory(String typeFormat, String shapeFormat) {
        return Optional.ofNullable(this.typeLoaderFactoryMap.get(new TypeLoaderRegistryKey(typeFormat, shapeFormat)));
    }

    public abstract String getName();

    private static class TypeLoaderRegistryKey {
        private final String typeFormat;
        private final String loaderFormat;

        public TypeLoaderRegistryKey(String typeFormat, String loaderFormat) {
            this.typeFormat = typeFormat;
            this.loaderFormat = loaderFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeLoaderRegistryKey that = (TypeLoaderRegistryKey)o;
            if (!this.typeFormat.equals(that.typeFormat)) {
                return false;
            }
            return this.loaderFormat.equals(that.loaderFormat);
        }

        public int hashCode() {
            int result = this.typeFormat.hashCode();
            result = 31 * result + this.loaderFormat.hashCode();
            return result;
        }
    }
}

