/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.loader.xml;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.datasense.catalog.builder.TypesCatalogBuilder;
import org.mule.datasense.catalog.loader.BaseTypesCatalogLoader;
import org.mule.datasense.catalog.loader.TypesCatalogLoaderContext;
import org.mule.datasense.common.loader.xml.XmlMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TypesCatalogXmlLoader
extends BaseTypesCatalogLoader {
    private static final String NS_MULE = "http://www.mulesoft.org/schema/mule/types";
    private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
    private static final QName ELEM_MULE = new QName("http://www.mulesoft.org/schema/mule/types", "mule");
    private static final QName ELEM_CATALOG = new QName("http://www.mulesoft.org/schema/mule/types", "catalog");
    private static final QName ELEM_TYPE = new QName("http://www.mulesoft.org/schema/mule/types", "type");
    private static final String ELEM_TYPE_ATTR_NAME = "name";
    private static final String ELEM_TYPE_ATTR_FORMAT = "format";
    private static final QName ELEM_SHAPE = new QName("http://www.mulesoft.org/schema/mule/types", "shape");
    private static final String ELEM_SHAPE_ATTR_FORMAT = "format";
    private static final String ELEM_SHAPE_ATTR_LOCATION = "location";
    private static final String ELEM_SHAPE_ATTR_ELEMENT = "element";
    private static final QName ELEM_EXAMPLE = new QName("http://www.mulesoft.org/schema/mule/types", "example");
    private static final String ELEM_EXAMPLE_ATTR_FORMAT = "format";
    private static final String ELEM_EXAMPLE_ATTR_LOCATION = "location";
    private static final String ELEM_EXAMPLE_ATTR_ELEMENT = "element";

    @Override
    public void load(File file, TypesCatalogLoaderContext typesCatalogLoaderContext) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Element documentElement = this.parseRootElement(new InputSource(fileInputStream));
            this.load(documentElement, typesCatalogLoaderContext);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected void load(String data, TypesCatalogLoaderContext typesCatalogLoaderContext) {
        try {
            this.load(this.parseRootElement(new InputSource(new StringReader(data))), typesCatalogLoaderContext);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void load(Element documentElement, TypesCatalogLoaderContext typesCatalogLoaderContext) {
        try {
            TypesCatalogBuilder typesCatalogBuilder = typesCatalogLoaderContext.getTypesCatalogBuilder();
            XmlMatcher.match(documentElement, ELEM_MULE).ifPresent(xmlMatcher -> xmlMatcher.matchMany(ELEM_CATALOG).forEach(catalog -> catalog.matchMany(ELEM_TYPE).forEach(type -> typesCatalogBuilder.addTypesResolver(typesResolverBuilder -> {
                type.matchAttribute(ELEM_TYPE_ATTR_NAME).ifPresent(typesResolverBuilder::name);
                type.matchAttribute("format").ifPresent(typesResolverBuilder::format);
                type.match(ELEM_SHAPE).ifPresent(shape -> {
                    shape.matchAttribute("location").ifPresent(typesResolverBuilder::shapeLocation);
                    shape.matchAttribute("format").ifPresent(typesResolverBuilder::shapeFormat);
                    shape.matchAttributeNode("element").ifPresent(elementAttr -> {
                        QName elementQName = XmlMatcher.resolveQName(elementAttr).orElse(QName.valueOf(elementAttr.getTextContent()));
                        typesResolverBuilder.shapeElement(elementQName.toString());
                    });
                    String content = shape.value();
                    if (!content.isEmpty()) {
                        typesResolverBuilder.shapeContent(content);
                    }
                });
                type.match(ELEM_EXAMPLE).ifPresent(example -> {
                    example.matchAttribute("location").ifPresent(typesResolverBuilder::exampleLocation);
                    example.matchAttribute("format").ifPresent(typesResolverBuilder::exampleFormat);
                    example.matchAttributeNode("element").ifPresent(elementAttr -> {
                        QName elementQName = XmlMatcher.resolveQName(elementAttr).orElse(QName.valueOf(elementAttr.getTextContent()));
                        typesResolverBuilder.exampleElement(elementQName.toString());
                    });
                    String content = example.value();
                    if (!content.isEmpty()) {
                        typesResolverBuilder.exampleContent(content);
                    }
                });
            }))));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private Element parseRootElement(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document.getDocumentElement();
    }
}

