/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.builder;

import java.net.URI;
import java.net.URISyntaxException;
import org.mule.datasense.catalog.model.resolver.ExampleTypeResolver;
import org.mule.datasense.catalog.model.resolver.ShapeTypeResolver;
import org.mule.datasense.catalog.model.resolver.SingleTypeResolver;
import org.mule.datasense.catalog.model.resolver.TypeResolver;

public class TypesResolverBuilder {
    private final URI baseUri;
    private String name;
    private String location;
    private String shapeFormat;
    private String shapeLocation;
    private String shapeContent;
    private String exampleFormat;
    private String exampleLocation;
    private String exampleContent;
    private String format;
    private String shapeElement;
    private String exampleElement;

    public TypesResolverBuilder(URI baseUri) {
        this.baseUri = baseUri;
    }

    public void name(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void format(String format) {
        this.format = format;
    }

    public void shapeFormat(String shapeFormat) {
        this.shapeFormat = shapeFormat;
    }

    public void shapeLocation(String shapeLocation) {
        this.shapeLocation = shapeLocation;
    }

    public void shapeContent(String shapeContent) {
        this.shapeContent = shapeContent;
    }

    public void shapeElement(String shapeElement) {
        this.shapeElement = shapeElement;
    }

    public void exampleFormat(String exampleFormat) {
        this.exampleFormat = exampleFormat;
    }

    public void exampleLocation(String exampleLocation) {
        this.exampleLocation = exampleLocation;
    }

    public void exampleElement(String exampleElement) {
        this.exampleElement = exampleElement;
    }

    public void exampleContent(String exampleContent) {
        this.exampleContent = exampleContent;
    }

    private URI resolveURI(String location) throws URISyntaxException {
        return this.baseUri != null ? this.baseUri.resolve(location) : new URI(location);
    }

    private String findTypeName(String name, String nativeName) {
        return nativeName != null ? nativeName : name;
    }

    public TypeResolver build() throws Exception {
        ShapeTypeResolver shapeTypeResolver = null;
        if (this.shapeFormat != null) {
            shapeTypeResolver = this.shapeLocation != null ? ShapeTypeResolver.createFromUrl(this.format, this.findTypeName(this.name, this.shapeElement), this.shapeFormat, this.resolveURI(this.shapeLocation).toURL(), this.shapeElement) : ShapeTypeResolver.createFromContent(this.format, this.findTypeName(this.name, this.shapeElement), this.shapeFormat, this.shapeContent);
        }
        ExampleTypeResolver exampleTypeResolver = null;
        if (this.exampleFormat != null) {
            if (this.exampleLocation != null) {
                URI exampleURI = this.resolveURI(this.exampleLocation);
                exampleTypeResolver = ExampleTypeResolver.createFromUrl(this.format, this.exampleElement, this.exampleFormat, exampleURI.toURL());
            } else {
                exampleTypeResolver = ExampleTypeResolver.createFromContent(this.format, this.exampleElement, this.exampleFormat, this.exampleContent);
            }
        }
        return new SingleTypeResolver(this.name, this.format, shapeTypeResolver, exampleTypeResolver);
    }
}

