/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml;

import java.io.File;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.raml.DataTypeRamlFragmentTypeLoader;
import org.mule.metadata.raml.RamlModelBuilderFactory;
import org.mule.metadata.raml.RamlTypeLibTypeLoader;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.RamlFragment;

public class RamlTypeLoader
implements TypeLoader {
    private final File ramlFile;
    private MetadataFormat metadataFormat;

    public RamlTypeLoader(File ramlFile, MetadataFormat metadataFormat) {
        this.ramlFile = ramlFile;
        this.metadataFormat = metadataFormat;
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        try {
            Optional<MetadataType> result;
            RamlModelResult ramlModelResult = RamlModelBuilderFactory.INSTANCE.createRamlModelBuilder().buildApi(this.ramlFile);
            if (ramlModelResult.hasErrors()) {
                throw new IllegalArgumentException(ramlModelResult.getValidationResults().toString());
            }
            if (ramlModelResult.getFragment() == RamlFragment.DataType) {
                DataTypeRamlFragmentTypeLoader dataTypeRamlFragmentTypeLoader = new DataTypeRamlFragmentTypeLoader(this.ramlFile, this.metadataFormat);
                result = dataTypeRamlFragmentTypeLoader.load(typeIdentifier, typeAlias);
            } else if (ramlModelResult.getLibrary() != null) {
                RamlTypeLibTypeLoader ramlTypeLibTypeLoader = new RamlTypeLibTypeLoader(this.ramlFile, this.metadataFormat);
                result = ramlTypeLibTypeLoader.load(typeIdentifier, typeAlias);
            } else {
                throw new IllegalArgumentException(String.format("Unsupported raml file '%s'.", this.ramlFile));
            }
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

