/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.handler;

import java.util.Arrays;
import java.util.List;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.raml.handler.AnyTypeDeclarationHandler;
import org.mule.metadata.raml.handler.ArrayTypeDeclarationHandler;
import org.mule.metadata.raml.handler.BooleanTypeDeclarationHandler;
import org.mule.metadata.raml.handler.DateOnlyTypeDeclarationHandler;
import org.mule.metadata.raml.handler.DateTimeOnlyTypeDeclarationHandler;
import org.mule.metadata.raml.handler.DateTimeTypeDeclarationHandler;
import org.mule.metadata.raml.handler.ExternalTypeDeclarationHandler;
import org.mule.metadata.raml.handler.FileTypeDeclarationHandler;
import org.mule.metadata.raml.handler.IntegerTypeDeclarationHandler;
import org.mule.metadata.raml.handler.JSONTypeDeclarationHandler;
import org.mule.metadata.raml.handler.NilTypeDeclarationHandler;
import org.mule.metadata.raml.handler.NumberTypeDeclarationHandler;
import org.mule.metadata.raml.handler.ObjectTypeDeclarationHandler;
import org.mule.metadata.raml.handler.ParsingContext;
import org.mule.metadata.raml.handler.StringTypeDeclarationHandler;
import org.mule.metadata.raml.handler.TimeOnlyTypeDeclarationHandler;
import org.mule.metadata.raml.handler.TypeDeclarationHandler;
import org.mule.metadata.raml.handler.UnionTypeDeclarationHandler;
import org.mule.metadata.raml.handler.XMLTypeDeclarationHandler;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class TypeDeclarationHandlerManager {
    private final MetadataFormat metadataFormat;
    private List<? extends TypeDeclarationHandler> typeDeclarationHandlers = Arrays.asList(new NilTypeDeclarationHandler(), new BooleanTypeDeclarationHandler(), new StringTypeDeclarationHandler(), new IntegerTypeDeclarationHandler(), new NumberTypeDeclarationHandler(), new DateTimeTypeDeclarationHandler(), new DateTimeOnlyTypeDeclarationHandler(), new DateOnlyTypeDeclarationHandler(), new TimeOnlyTypeDeclarationHandler(), new FileTypeDeclarationHandler(), new ArrayTypeDeclarationHandler(), new ObjectTypeDeclarationHandler(), new UnionTypeDeclarationHandler(), new XMLTypeDeclarationHandler(), new JSONTypeDeclarationHandler(), new ExternalTypeDeclarationHandler(), new AnyTypeDeclarationHandler());

    public TypeDeclarationHandlerManager(MetadataFormat metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, ParsingContext parsingContext) {
        if (typeDeclaration == null) {
            throw new IllegalArgumentException(String.format("Unhandled null type declaration", new Object[0]));
        }
        if (parsingContext.isTypeBuilderPresent(typeDeclaration)) {
            return parsingContext.getTypeBuilder(typeDeclaration).get();
        }
        BaseTypeBuilder root = BaseTypeBuilder.create((MetadataFormat)this.metadataFormat);
        for (TypeDeclarationHandler typeDeclarationHandler : this.typeDeclarationHandlers) {
            if (!typeDeclarationHandler.handles(typeDeclaration)) continue;
            return typeDeclarationHandler.handle(typeDeclaration, root, this, parsingContext);
        }
        throw new IllegalArgumentException(String.format("Unhandled type declaration %s", typeDeclaration.type()));
    }
}

