/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.dw;

import java.util.HashMap;
import junit.framework.AssertionFailedError;
import org.junit.Test;
import org.mule.metadata.ExpressionLanguageMetadataServiceUtils;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class DwShapeTypeLoaderTest {
    @Test
    public void useDwTypeLoader() {
        String content = "type root = {|\n           name: String,\n           age: Number\n         |}";
        TypeLoader typeLoader = ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService().createTypeLoader(content, MetadataFormat.JAVA);
        MetadataType metadataType = (MetadataType)typeLoader.load("root").orElseThrow(() -> new AssertionFailedError("expected type not found."));
        System.out.println(new MetadataTypeWriter().toString(metadataType));
    }

    @Test
    public void useDwTypeWriter() {
        BaseTypeBuilder baseTypeBuilder = new BaseTypeBuilder(MetadataFormat.XML);
        ObjectTypeBuilder objectTypeBuilder = baseTypeBuilder.objectType();
        objectTypeBuilder.addField().required().key("f1").value().stringType();
        MetadataType metadataType = baseTypeBuilder.build();
        ExpressionLanguageMetadataService.MetadataTypeSerializer weaveTypeSerializer = ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService().getTypeSerializer();
        HashMap<String, MetadataType> catalog = new HashMap<String, MetadataType>();
        catalog.put("root", metadataType);
        String serialize = weaveTypeSerializer.serialize(catalog);
        System.out.println(serialize);
        MetadataType metadataType1 = (MetadataType)ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService().createTypeLoader(serialize, MetadataFormat.JAVA).load("root").orElseThrow(() -> new AssertionFailedError("expected type not found."));
        System.out.println(new MetadataTypeWriter().toString(metadataType1));
    }
}

