/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.dw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.ExpressionLanguageMetadataServiceUtils;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.dw.DwExampleTypeLoader;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
@Ignore
public class DwExampleTypeLoaderTest {
    private String name;
    private File example;
    private File expected;
    private MetadataFormat metadataFormat;

    public DwExampleTypeLoaderTest(String name, File example, File expected, MetadataFormat metadataFormat) {
        this.name = name;
        this.example = example;
        this.expected = expected;
        this.metadataFormat = metadataFormat;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() throws URISyntaxException {
        ArrayList<Object[]> testInput = new ArrayList<Object[]>();
        URI baseFolder = DwExampleTypeLoaderTest.class.getResource("").toURI();
        File testFolder = new File(baseFolder);
        File[] scenariosByFormat = testFolder.listFiles();
        if (scenariosByFormat != null) {
            Arrays.stream(scenariosByFormat).filter(File::isDirectory).forEach(scenariosForFormat -> {
                File[] scenarios = scenariosForFormat.listFiles();
                if (scenarios != null) {
                    Arrays.stream(scenarios).filter(File::isDirectory).forEach(scenario -> {
                        if (!scenario.getName().startsWith("skip")) {
                            String format = scenariosForFormat.getName();
                            File input = new File((File)scenario, "in0." + format);
                            File output = new File((File)scenario, "out.type");
                            MetadataFormat metadataFormat = MetadataFormats.fromId((String)format);
                            testInput.add(new Object[]{format + "-" + scenario.getName(), input, output, metadataFormat});
                        }
                    });
                }
            });
        }
        return testInput;
    }

    @Test
    public void loadedMetadataIsTheExpected() throws IOException, SAXException {
        Optional root = new DwExampleTypeLoader(this.example, this.metadataFormat, ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService()).load(null);
        Assert.assertThat((Object)root.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        String actual = new MetadataTypeWriter().toString((MetadataType)root.get());
        Assert.assertThat((Object)actual, (Matcher)IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)IOUtils.toString((InputStream)new FileInputStream(this.expected))));
    }
}

