/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.dw;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.dw.DwTypeWriter;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class DwTypeWriterTest {
    private ExpressionLanguageMetadataService mockService;
    private ExpressionLanguageMetadataService.MetadataTypeSerializer mockSerializer;
    private MetadataType mockType;

    @Before
    public void setUp() {
        this.mockService = (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class);
        this.mockSerializer = (ExpressionLanguageMetadataService.MetadataTypeSerializer)Mockito.mock(ExpressionLanguageMetadataService.MetadataTypeSerializer.class);
        this.mockType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)this.mockService.getTypeSerializer()).thenReturn((Object)this.mockSerializer);
    }

    @Test
    public void testToString() {
        DwTypeWriter writer = new DwTypeWriter(this.mockService);
        Mockito.when((Object)this.mockSerializer.serialize(Mockito.anyMap())).thenReturn((Object)"serialized");
        Assert.assertEquals((Object)"serialized", (Object)writer.toString(this.mockType));
    }

    @Test
    public void testWriteWithName() {
        DwTypeWriter writer = new DwTypeWriter(this.mockService);
        Mockito.when((Object)this.mockSerializer.serialize(Mockito.anyMap())).thenReturn((Object)"named");
        Assert.assertEquals((Object)"named", (Object)writer.write(this.mockType, "customName"));
    }

    @Test
    public void testWriteWithCatalog() {
        DwTypeWriter writer = new DwTypeWriter(this.mockService);
        HashMap<String, MetadataType> catalog = new HashMap<String, MetadataType>();
        catalog.put("foo", this.mockType);
        Mockito.when((Object)this.mockSerializer.serialize(catalog)).thenReturn((Object)"catalog");
        Assert.assertEquals((Object)"catalog", (Object)writer.write(catalog));
    }

    @Test
    public void testWriteWithEmptyCatalog() {
        DwTypeWriter writer = new DwTypeWriter(this.mockService);
        Map catalog = Collections.emptyMap();
        Mockito.when((Object)this.mockSerializer.serialize(catalog)).thenReturn((Object)"");
        Assert.assertEquals((Object)"", (Object)writer.write(catalog));
    }
}

