/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.dw;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public abstract class DwBasedTypeLoader
implements TypeLoader {
    private final TypeLoader delegate;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

    public DwBasedTypeLoader(File file, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.delegate = this.createTypeLoader(file, this.getMetadataFormat());
    }

    public DwBasedTypeLoader(String content, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.delegate = this.createTypeLoader(content, this.getMetadataFormat());
    }

    protected abstract TypeLoader createTypeLoader(File var1, MetadataFormat var2);

    protected abstract TypeLoader createTypeLoader(String var1, MetadataFormat var2);

    public static String getMimeType(MetadataFormat metadataFormat) {
        Preconditions.checkNotNull((Object)metadataFormat);
        return (String)metadataFormat.getValidMimeTypes().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown mime type for " + metadataFormat.getId()));
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        return this.delegate.load(typeIdentifier, typeAlias);
    }

    protected abstract MetadataFormat getMetadataFormat();

    protected ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.expressionLanguageMetadataService;
    }
}

