/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.csv.CsvTypeLoader;
import org.mule.metadata.map.MapTypeLoader;
import org.mule.metadata.raml.RamlTypeLoader;

@RunWith(value=Parameterized.class)
public class DisallowExternalReferencesTypeLoaderTest {
    private static final String PROPERTY = "org.mule.metadata.raml.disallowExternalReferences";
    private static final String RESOURCE_PATTERN = "/org/mule/metadata/raml_disallow_external/%s/data.raml";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Function<File, TypeLoader> typeLoaderFunction;
    private String path;

    public DisallowExternalReferencesTypeLoaderTest(String name, Function<File, TypeLoader> typeLoaderFunction) {
        this.typeLoaderFunction = typeLoaderFunction;
        this.path = String.format(RESOURCE_PATTERN, name);
    }

    private static void disallowExternalReferences() {
        System.setProperty(PROPERTY, "true");
    }

    private static void resetDisallowExternalReferences() {
        System.clearProperty(PROPERTY);
    }

    private Optional<MetadataType> loadType(Function<File, TypeLoader> typeLoaderFunction, String path) {
        File file = FileUtils.toFile((URL)DisallowExternalReferencesTypeLoaderTest.class.getResource(path));
        return typeLoaderFunction.apply(file).load("Root");
    }

    private void externalResourceDisabledWithSystemPropertySet(Function<File, TypeLoader> typeLoaderFunction, String path) {
        DisallowExternalReferencesTypeLoaderTest.disallowExternalReferences();
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"Resource loading not allowed"));
        try {
            this.loadType(typeLoaderFunction, path);
        }
        finally {
            DisallowExternalReferencesTypeLoaderTest.resetDisallowExternalReferences();
        }
    }

    @Test
    public void externalResourceDisabledWithSystemPropertySet() {
        this.externalResourceDisabledWithSystemPropertySet(this.typeLoaderFunction, this.path);
    }

    @Test
    public void externalResourceEnabledByDefault() {
        Assert.assertTrue((boolean)this.loadType(this.typeLoaderFunction, this.path).isPresent());
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"map", MapTypeLoader::new}, {"csv", CsvTypeLoader::new}, {"fragment", file -> new RamlTypeLoader(file, MetadataFormat.JAVA)}, {"typelib", file -> new RamlTypeLoader(file, MetadataFormat.JAVA)});
    }
}

