/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.dw;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.dw.DwBasedExampleTypeLoader;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class DwBasedExampleTypeLoaderTest {
    private ExpressionLanguageMetadataService mockService;
    private MetadataFormat mockFormat;
    private TypeLoader mockLoader;

    @Before
    public void setUp() {
        this.mockService = (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class);
        this.mockFormat = (MetadataFormat)Mockito.mock(MetadataFormat.class);
        this.mockLoader = (TypeLoader)Mockito.mock(TypeLoader.class);
    }

    @Test
    public void testConstructors() {
        File file = (File)Mockito.mock(File.class);
        TestDwBasedExampleTypeLoader loader1 = new TestDwBasedExampleTypeLoader(file, this.mockService, this.mockLoader, this.mockFormat);
        TestDwBasedExampleTypeLoader loader2 = new TestDwBasedExampleTypeLoader("content", this.mockService, this.mockLoader, this.mockFormat);
        Assert.assertNotNull((Object)((Object)loader1));
        Assert.assertNotNull((Object)((Object)loader2));
    }

    @Test
    public void testCreateTypeLoaderMethods() {
        File file = (File)Mockito.mock(File.class);
        TestDwBasedExampleTypeLoader loader = new TestDwBasedExampleTypeLoader(file, this.mockService, this.mockLoader, this.mockFormat);
        Assert.assertEquals((Object)this.mockLoader, (Object)loader.createTypeLoader(file, this.mockFormat));
        Assert.assertEquals((Object)this.mockLoader, (Object)loader.createTypeLoader("content", this.mockFormat));
    }

    static class TestDwBasedExampleTypeLoader
    extends DwBasedExampleTypeLoader {
        private final TypeLoader loader;
        private final MetadataFormat format;

        public TestDwBasedExampleTypeLoader(File file, ExpressionLanguageMetadataService service, TypeLoader loader, MetadataFormat format) {
            super(file, service);
            this.loader = loader;
            this.format = format;
        }

        public TestDwBasedExampleTypeLoader(String content, ExpressionLanguageMetadataService service, TypeLoader loader, MetadataFormat format) {
            super(content, service);
            this.loader = loader;
            this.format = format;
        }

        protected TypeLoader createTypeLoader(File file, MetadataFormat metadataFormat) {
            return this.loader;
        }

        protected TypeLoader createTypeLoader(String content, MetadataFormat metadataFormat) {
            return this.loader;
        }

        protected MetadataFormat getMetadataFormat() {
            return this.format;
        }
    }
}

