/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.csv;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.raml.DataTypeRamlFragmentTypeLoader;

public class CsvTypeLoader
implements TypeLoader {
    private static final List<Class<? extends MetadataType>> validFieldTypes = Arrays.asList(StringType.class, NumberType.class, BooleanType.class, DateType.class, DateTimeType.class);
    private final DataTypeRamlFragmentTypeLoader dataTypeRamlFragmentTypeLoader;

    public CsvTypeLoader(File file) {
        this.dataTypeRamlFragmentTypeLoader = new DataTypeRamlFragmentTypeLoader(file, MetadataFormat.CSV);
    }

    public CsvTypeLoader(String content) {
        this.dataTypeRamlFragmentTypeLoader = new DataTypeRamlFragmentTypeLoader(content, MetadataFormat.CSV);
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        return this.dataTypeRamlFragmentTypeLoader.load(typeIdentifier, typeAlias).map(metadataType -> {
            this.validate((MetadataType)metadataType);
            return metadataType;
        });
    }

    private void validateFieldType(MetadataType metadataType) {
        for (Class<? extends MetadataType> validFieldMetadataTypeClass : validFieldTypes) {
            if (!validFieldMetadataTypeClass.isAssignableFrom(metadataType.getClass())) continue;
            return;
        }
        throw new RuntimeException("Invalid RAML type for CSV format. Only primitive type fields are allowed.");
    }

    private void validate(MetadataType metadataType) {
        MetadataType elementMetadataType;
        if (metadataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)metadataType;
            elementMetadataType = arrayType.getType();
            if (!(elementMetadataType instanceof ObjectType)) {
                throw new RuntimeException("Invalid RAML type for CSV format. Only arrays of objects with primitive type fields are allowed.");
            }
        } else {
            throw new RuntimeException("Invalid RAML type for CSV format. Only arrays of objects with primitive type fields are allowed.");
        }
        ObjectType objectType = (ObjectType)elementMetadataType;
        objectType.getFields().forEach(objectFieldType -> this.validateFieldType(objectFieldType.getValue()));
    }
}

