/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.dsl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;

public final class DefaultDslResolvingContext
implements DslResolvingContext {
    private final Map<String, ExtensionModel> extensions;
    private final TypeCatalog typeCatalog;

    public DefaultDslResolvingContext(Set<ExtensionModel> extensions) {
        this.extensions = extensions.stream().collect(Collectors.toMap(ExtensionModel::getName, e -> e));
        this.typeCatalog = TypeCatalog.getDefault(extensions);
    }

    @Override
    public Optional<ExtensionModel> getExtension(String name) {
        return Optional.ofNullable(this.extensions.get(name));
    }

    @Override
    public Collection<ExtensionModel> getExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public TypeCatalog getTypeCatalog() {
        return this.typeCatalog;
    }
}

