/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.declaration.fluent;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;

public abstract class BaseDeclaration<T extends BaseDeclaration>
implements DescribedObject {
    private final Map<Class<? extends ModelProperty>, ModelProperty> modelProperties = new HashMap<Class<? extends ModelProperty>, ModelProperty>();
    private String description = "";
    private DisplayModel displayModel;

    public Set<ModelProperty> getModelProperties() {
        return Collections.unmodifiableSet(new HashSet<ModelProperty>(this.modelProperties.values()));
    }

    public <P extends ModelProperty> Optional<P> getModelProperty(Class<P> propertyType) {
        return Optional.ofNullable(this.modelProperties.get(propertyType));
    }

    public T addModelProperty(ModelProperty modelProperty) {
        if (modelProperty == null) {
            throw new IllegalArgumentException("Cannot add a null model property");
        }
        this.modelProperties.put(modelProperty.getClass(), modelProperty);
        return (T)this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public void setDisplayModel(DisplayModel displayModel) {
        this.displayModel = displayModel;
    }
}

