/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;

public final class ImportedTypeModel {
    private final String originExtensionName;
    private final MetadataType importedType;

    public ImportedTypeModel(String originExtensionName, MetadataType importedType) {
        if (StringUtils.isBlank((CharSequence)originExtensionName)) {
            throw new IllegalArgumentException("originExtensionName cannot be blank");
        }
        if (importedType == null) {
            throw new IllegalArgumentException("importedType cannot be null");
        }
        this.originExtensionName = originExtensionName;
        this.importedType = importedType;
    }

    public String getOriginExtensionName() {
        return this.originExtensionName;
    }

    public MetadataType getImportedType() {
        return this.importedType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImportedTypeModel) {
            ImportedTypeModel other = (ImportedTypeModel)obj;
            return this.originExtensionName.equals(other.getOriginExtensionName()) && this.importedType.equals(other.getImportedType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.importedType, this.originExtensionName);
    }
}

