/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.i18n;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.ReloadControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class I18nMessageFactory {
    public static final ResourceBundle.Control DEFAULT_RELOAD_CONTROL = new ReloadControl.Always();
    private static final int STATIC_ERROR_CODE = -1;
    private static final transient Object[] EMPTY_ARGS = new Object[0];
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final ResourceBundle.Control reloadControl = new ResourceBundle.Control(){
        private List<String> formats = new ArrayList<String>(I18nMessageFactory.access$000(FORMAT_PROPERTIES, FORMAT_CLASS));

        @Override
        public List<String> getFormats(String baseName) {
            return this.formats;
        }
    };

    private static <T> List<T> union(List<T> list1, List<T> list2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(list1);
        set.addAll(list2);
        return new ArrayList(set);
    }

    protected static String getBundlePath(String bundleName) {
        return "META-INF/services/org/mule/runtime/core/i18n/" + bundleName + "-messages";
    }

    protected I18nMessage createMessage(String bundlePath, int code, Object arg) {
        return this.createMessage(bundlePath, code, new Object[]{arg});
    }

    protected I18nMessage createMessage(String bundlePath, int code, Object arg1, Object arg2) {
        return this.createMessage(bundlePath, code, new Object[]{arg1, arg2});
    }

    protected I18nMessage createMessage(String bundlePath, int code, Object arg1, Object arg2, Object arg3) {
        return this.createMessage(bundlePath, code, new Object[]{arg1, arg2, arg3});
    }

    protected I18nMessage createMessage(String bundlePath, int code, Object ... arguments) {
        String messageString = this.getString(bundlePath, code, arguments);
        return new I18nMessage(messageString, code, arguments);
    }

    protected I18nMessage createMessage(String bundlePath, int code) {
        String messageString = this.getString(bundlePath, code, null);
        return new I18nMessage(messageString, code, EMPTY_ARGS);
    }

    public static I18nMessage createStaticMessage(String message) {
        return new I18nMessage(message, -1, EMPTY_ARGS);
    }

    public static I18nMessage createStaticMessage(String message, Object ... arguments) {
        return new I18nMessage(String.format(message, arguments), -1, EMPTY_ARGS);
    }

    protected String getString(String bundlePath, int code) {
        return this.getString(bundlePath, code, null);
    }

    protected String getString(String bundlePath, int code, Object arg) {
        Object[] arguments = new Object[]{arg};
        return this.getString(bundlePath, code, arguments);
    }

    protected String getString(String bundlePath, int code, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return this.getString(bundlePath, code, arguments);
    }

    protected String getString(String bundlePath, int code, Object[] args) {
        ResourceBundle bundle = this.getBundle(bundlePath);
        try {
            String m = bundle.getString(String.valueOf(code));
            if (m == null) {
                this.logger.error("Failed to find message for id " + code + " in resource bundle " + bundlePath);
                return "";
            }
            return MessageFormat.format(m, args);
        }
        catch (MissingResourceException e) {
            this.logger.error("Failed to find message for id " + code + " in resource bundle " + bundlePath);
            return "";
        }
    }

    protected ResourceBundle getBundle(String bundlePath) {
        Locale locale = Locale.getDefault();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Loading resource bundle: " + bundlePath + " for locale " + locale);
        }
        return ResourceBundle.getBundle(bundlePath, locale, this.getClassLoader(), this.getReloadControl());
    }

    protected ClassLoader getClassLoader() {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        return ccl == null ? this.getClass().getClassLoader() : ccl;
    }

    protected ResourceBundle.Control getReloadControl() {
        return reloadControl;
    }

    static /* synthetic */ List access$000(List x0, List x1) {
        return I18nMessageFactory.union(x0, x1);
    }
}

