/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.app.declaration;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.app.declaration.ComponentElementDeclaration;
import org.mule.runtime.api.app.declaration.NamedElementDeclaration;
import org.mule.runtime.api.util.Preconditions;

public final class FlowElementDeclaration
implements NamedElementDeclaration {
    private List<ComponentElementDeclaration> components = new LinkedList<ComponentElementDeclaration>();
    private String name;
    private String initialState;
    private String processingStrategy;

    public FlowElementDeclaration() {
    }

    public FlowElementDeclaration(String name) {
        this.setName(name);
    }

    public List<ComponentElementDeclaration> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public FlowElementDeclaration addComponent(ComponentElementDeclaration declaration) {
        this.components.add(declaration);
        return this;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public String getProcessingStrategy() {
        return this.processingStrategy;
    }

    public void setProcessingStrategy(String processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        Preconditions.checkArgument(name != null && !name.trim().isEmpty(), "Flow declaration requires a non blank name");
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlowElementDeclaration)) {
            return false;
        }
        FlowElementDeclaration that = (FlowElementDeclaration)o;
        return this.name.equals(that.name) && !(this.initialState == null ? that.initialState != null : !this.initialState.equals(that.initialState)) && this.components.equals(that.components) && (this.processingStrategy != null ? this.processingStrategy.equals(that.processingStrategy) : that.processingStrategy == null);
    }

    public int hashCode() {
        int result = this.components.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.initialState != null ? this.initialState.hashCode() : 0);
        result = 31 * result + (this.processingStrategy != null ? this.processingStrategy.hashCode() : 0);
        return result;
    }
}

