/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl.header;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.commons.lang.Validate;
import org.mule.modules.wsdl.WSDLInvocation;
import org.mule.modules.wsdl.header.SOAPHeaderBuilder;
import org.mule.modules.wsdl.header.SOAPHeaderException;

public class WsseSecurityHeaderBuilder
implements SOAPHeaderBuilder {
    private String username;
    private String password;

    public WsseSecurityHeaderBuilder(String username, String password) {
        Validate.notNull((Object)username, (String)"The user name cannot be null or empty.");
        Validate.notNull((Object)password, (String)"The password cannot be null or empty.");
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void build(SOAPHeader header, WSDLInvocation wsdlInvocation) throws SOAPHeaderException {
        try {
            SOAPElement security = header.addChildElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            SOAPElement usernameToken = security.addChildElement("UsernameToken", "wsse");
            usernameToken.addAttribute(new QName("xmlns:wsu"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SOAPElement usernameElement = usernameToken.addChildElement("Username", "wsse");
            usernameElement.addTextNode(this.username);
            SOAPElement passwordElement = usernameToken.addChildElement("Password", "wsse");
            passwordElement.addTextNode(this.password);
        }
        catch (SOAPException e) {
            throw new SOAPHeaderException(e);
        }
    }
}

