/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl.header;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.commons.lang.Validate;
import org.mule.modules.wsdl.WSDLInvocation;
import org.mule.modules.wsdl.header.SOAPHeaderBuilder;
import org.mule.modules.wsdl.header.SOAPHeaderException;

public class SalesForceHeaderBuilder
implements SOAPHeaderBuilder {
    private String salesForceSessionId;

    public SalesForceHeaderBuilder(String salesForceSessionId) {
        Validate.notEmpty((String)salesForceSessionId, (String)"The SalesForce Session ID cannot be null or empty.");
        this.salesForceSessionId = salesForceSessionId;
    }

    @Override
    public void build(SOAPHeader header, WSDLInvocation wsdlInvocation) throws SOAPHeaderException {
        String wsdlNamespace = wsdlInvocation.getWsdlNamespace();
        String headerQNamePrefix = wsdlInvocation.getHeaderQNamePrefix();
        Validate.notEmpty((String)wsdlNamespace, (String)"WSDLInvocation must have wsdlNamespace defined.");
        Validate.notEmpty((String)headerQNamePrefix, (String)"WSDLInvocation must have headerQNamePrefix defined.");
        try {
            SOAPElement allowFieldTruncationHeader = header.addChildElement(new QName(wsdlNamespace, "AllowFieldTruncationHeader", headerQNamePrefix));
            allowFieldTruncationHeader.addChildElement(new QName(wsdlNamespace, "allowFieldTruncation", headerQNamePrefix)).addTextNode("1");
            SOAPElement debuggingHeader = header.addChildElement(new QName(wsdlNamespace, "DebuggingHeader", headerQNamePrefix));
            SOAPElement categories = debuggingHeader.addChildElement(new QName(wsdlNamespace, "categories", headerQNamePrefix));
            categories.addChildElement(new QName(wsdlNamespace, "category", headerQNamePrefix)).addTextNode("Apex_code");
            categories.addChildElement(new QName(wsdlNamespace, "level", headerQNamePrefix)).addTextNode("Info");
            debuggingHeader.addChildElement(new QName(wsdlNamespace, "debugLevel", headerQNamePrefix)).addTextNode("Detail");
            SOAPElement callOptions = header.addChildElement(new QName(wsdlNamespace, "CallOptions", headerQNamePrefix));
            callOptions.addChildElement(new QName(wsdlNamespace, "client", headerQNamePrefix)).addTextNode("32.0");
            SOAPElement sessionHeader = header.addChildElement(new QName(wsdlNamespace, "SessionHeader", headerQNamePrefix));
            sessionHeader.addChildElement(new QName(wsdlNamespace, "sessionId", headerQNamePrefix)).addTextNode(this.salesForceSessionId);
        }
        catch (SOAPException e) {
            throw new SOAPHeaderException(e);
        }
    }
}

