/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ssh.multiplexer.connectivity;

import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.3.6.1.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.3.6.1.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.ssh.multiplexer.connectivity.SshConnectorAdapter;
import org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionKey;
import org.mule.modules.ssh.multiplexer.pooling.DevkitGenericKeyedObjectPool;
import org.mule.modules.ssh.multiplexer.processors.ConnectivityProcessor;

public class SshConnectorConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<SshConnectorAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectionManagementConnectionManager<SshConnectorConnectionKey, SshConnectorAdapter, Object> {
    private String username;
    private String password;
    private String privateKeyFile;
    private String host;
    private Integer port;
    private Integer timeout;
    private String callbackFlowName;
    private boolean shellMode;
    private boolean disableKnownHostsVerification;
    private String knownHostsFile;
    private Integer receiverBufferSize;
    protected MuleContext muleContext;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "SSH";
    private static final String MODULE_VERSION = "1.2.2";
    private static final String DEVKIT_VERSION = "3.6.1";
    private static final String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private static final String MIN_MULE_VERSION = "3.5.0";

    public void setPort(Integer value) {
        this.port = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPrivateKeyFile(String value) {
        this.privateKeyFile = value;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setCallbackFlowName(String value) {
        this.callbackFlowName = value;
    }

    public String getCallbackFlowName() {
        return this.callbackFlowName;
    }

    public void setShellMode(boolean value) {
        this.shellMode = value;
    }

    public boolean getShellMode() {
        return this.shellMode;
    }

    public void setDisableKnownHostsVerification(boolean value) {
        this.disableKnownHostsVerification = value;
    }

    public boolean getDisableKnownHostsVerification() {
        return this.disableKnownHostsVerification;
    }

    public void setKnownHostsFile(String value) {
        this.knownHostsFile = value;
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setReceiverBufferSize(Integer value) {
        this.receiverBufferSize = value;
    }

    public Integer getReceiverBufferSize() {
        return this.receiverBufferSize;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SshConnectorAdapter acquireConnection(SshConnectorConnectionKey key) throws Exception {
        return (SshConnectorAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(SshConnectorConnectionKey key, SshConnectorAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(SshConnectorConnectionKey key, SshConnectorAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, SshConnectorAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, this.muleContext);
    }

    @Override
    public SshConnectorConnectionKey getDefaultConnectionKey() {
        return new SshConnectorConnectionKey(this.getUsername(), this.getPassword(), this.getPrivateKeyFile(), this.getHost(), this.getPort());
    }

    @Override
    public SshConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("username").getGenericType(), null, this.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("password").getGenericType(), null, this.getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            String _transformedPrivateKeyFile = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("privateKeyFile").getGenericType(), null, this.getPrivateKeyFile());
            String _transformedHost = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("host").getGenericType(), null, this.getHost());
            if (_transformedHost == null) {
                throw new UnableToAcquireConnectionException("Parameter host in method connect can't be null because is not @Optional");
            }
            Integer _transformedPort = (Integer)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("port").getGenericType(), null, this.getPort());
            if (_transformedPort == null) {
                throw new UnableToAcquireConnectionException("Parameter port in method connect can't be null because is not @Optional");
            }
            return new SshConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedPrivateKeyFile, _transformedHost, _transformedPort);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public SshConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        if (this.hasConnectionKeysOverride(messageProcessor).booleanValue()) {
            ConnectivityProcessor connectivityProcessor = (ConnectivityProcessor)messageProcessor;
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_usernameType"), null, connectivityProcessor.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_passwordType"), null, connectivityProcessor.getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            String _transformedPrivateKeyFile = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_privateKeyFileType"), null, connectivityProcessor.getPrivateKeyFile());
            String _transformedHost = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_hostType"), null, connectivityProcessor.getHost());
            if (_transformedHost == null) {
                throw new UnableToAcquireConnectionException("Parameter host in method connect can't be null because is not @Optional");
            }
            Integer _transformedPort = (Integer)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_portType"), null, connectivityProcessor.getPort());
            if (_transformedPort == null) {
                throw new UnableToAcquireConnectionException("Parameter port in method connect can't be null because is not @Optional");
            }
            return new SshConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedPrivateKeyFile, _transformedHost, _transformedPort);
        }
        return this.getEvaluatedConnectionKey(event);
    }

    private Boolean hasConnectionKeysOverride(MessageProcessor messageProcessor) {
        if (messageProcessor == null || !(messageProcessor instanceof ConnectivityProcessor)) {
            return false;
        }
        ConnectivityProcessor connectivityProcessor = (ConnectivityProcessor)messageProcessor;
        if (connectivityProcessor.getUsername() != null) {
            return true;
        }
        return false;
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        SshConnectorAdapter connector = new SshConnectorAdapter();
        connector.setShellMode(this.getShellMode());
        connector.setTimeout(this.getTimeout());
        connector.setDisableKnownHostsVerification(this.getDisableKnownHostsVerification());
        connector.setReceiverBufferSize(this.getReceiverBufferSize());
        connector.setCallbackFlowName(this.getCallbackFlowName());
        connector.setKnownHostsFile(this.getKnownHostsFile());
        return connector;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<Object, SshConnectorConnectionKey> connection) {
        return (ConnectionManagementConnectorAdapter)((Object)connection);
    }

    @Override
    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        return (ConnectionManagementConnectionAdapter)((Object)adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        SshConnectorAdapter connection = null;
        SshConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)ConnectivityTestingErrorHandler.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }
}

