/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ssh.multiplexer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.signature.SignatureDSA;
import net.schmizz.sshj.signature.SignatureRSA;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.construct.Flow;
import org.mule.modules.ssh.multiplexer.CallbackOutputStream;

public class SshConnector
implements MuleContextAware {
    private static final Logger logger = Logger.getLogger(SshConnector.class);
    private static final String SSH_CALLBACK_USER = "SSH_CALLBACK_USER";
    private MuleContext muleContext;
    private Integer timeout;
    private String callbackFlowName;
    private boolean shellMode = false;
    private boolean disableKnownHostsVerification = false;
    private String knownHostsFile = "";
    private Flow callbackFlow = null;
    private Integer receiverBufferSize = 8192;
    private SSHClient client;
    private Session session;
    private OutputStream writerStream;
    private OutputStream callbackStream;
    private Session.Shell shell;
    private String username;

    public void init() {
        this.callbackFlow = (Flow)this.muleContext.getRegistry().lookupFlowConstruct(this.callbackFlowName);
        if (this.callbackFlow == null) {
            throw new IllegalArgumentException("Could not find callback flow with name " + this.callbackFlowName);
        }
    }

    public void connect(String username, String password, String privateKeyFile, String host, Integer port) throws ConnectionException {
        DefaultConfig configDSAFirst = new DefaultConfig();
        DefaultConfig configRSAFirst = new DefaultConfig();
        configDSAFirst.setSignatureFactories(Arrays.asList(new Factory.Named<Signature>(){

            public Signature create() {
                return new SignatureDSA();
            }

            public String getName() {
                return KeyType.DSA.toString();
            }
        }, new Factory.Named<Signature>(){

            public Signature create() {
                return new SignatureRSA();
            }

            public String getName() {
                return KeyType.RSA.toString();
            }
        }));
        configRSAFirst.setSignatureFactories(Arrays.asList(new Factory.Named<Signature>(){

            public Signature create() {
                return new SignatureRSA();
            }

            public String getName() {
                return KeyType.RSA.toString();
            }
        }, new Factory.Named<Signature>(){

            public Signature create() {
                return new SignatureDSA();
            }

            public String getName() {
                return KeyType.DSA.toString();
            }
        }));
        SSHClient clientRSAFirst = new SSHClient((Config)configRSAFirst);
        SSHClient clientDSAFirst = new SSHClient((Config)configDSAFirst);
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (this.disableKnownHostsVerification) {
                logger.warn((Object)"KNOWN HOST VERIFICATION IS DISABLED -- HOST IS NOT AUTHENTICATED");
                clientRSAFirst.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
                clientDSAFirst.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            } else if (this.knownHostsFile != null && !this.knownHostsFile.isEmpty()) {
                logger.warn((Object)("Loading known hosts file from " + this.knownHostsFile));
                File knownHosts = new File(this.knownHostsFile);
                if (!knownHosts.exists() || !knownHosts.canRead()) {
                    throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "", "Error loading known hosts: Can't read " + this.knownHostsFile);
                }
                clientRSAFirst.loadKnownHosts(knownHosts);
                clientDSAFirst.loadKnownHosts(knownHosts);
            } else {
                logger.warn((Object)"Loading known hosts file from default locations");
                clientRSAFirst.loadKnownHosts();
                clientDSAFirst.loadKnownHosts();
            }
        }
        catch (IOException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, e.getMessage(), "Error loading known hosts", (Throwable)e);
        }
        if (this.timeout != null) {
            clientDSAFirst.setTimeout(this.timeout.intValue());
            clientRSAFirst.setTimeout(this.timeout.intValue());
            clientDSAFirst.getTransport().setTimeoutMs(this.timeout.intValue());
            clientRSAFirst.getTransport().setTimeoutMs(this.timeout.intValue());
        }
        try {
            clientRSAFirst.connect(host, port.intValue());
            this.client = clientRSAFirst;
        }
        catch (TransportException e) {
            logger.info((Object)"RSA signature failed, trying DSA");
            try {
                clientDSAFirst.connect(host, port.intValue());
                this.client = clientDSAFirst;
            }
            catch (TransportException e2) {
                logger.info((Object)"DSA and RSA signature failed");
                throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e2.getMessage(), String.format("Could not reach ssh server at %s:%d", host, port), (Throwable)e2);
            }
            catch (IOException e3) {
                throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e3.getMessage(), String.format("Could not reach ssh server at %s:%d", host, port), (Throwable)e3);
            }
        }
        catch (IOException e) {
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e.getMessage(), String.format("Could not reach ssh server at %s:%d", host, port), (Throwable)e);
        }
        try {
            if (privateKeyFile == null || privateKeyFile.isEmpty()) {
                logger.debug((Object)"Private key file location is empty, attempting username/password auth");
                this.client.authPassword(username, password);
            } else {
                logger.debug((Object)("Attempting public key auth from file " + privateKeyFile));
                FileKeyProvider provider = new PKCS8KeyFile.Factory().create();
                provider.init(new File(privateKeyFile), PasswordUtils.createOneOff((char[])password.toCharArray()));
                this.client.authPublickey(username, new KeyProvider[]{provider});
            }
            this.session = this.client.startSession();
        }
        catch (UserAuthException e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, e.getMessage(), "Could not login", (Throwable)e);
        }
        catch (TransportException e) {
            this.throwCannotReachException((Exception)((Object)e));
        }
        catch (net.schmizz.sshj.connection.ConnectionException e) {
            this.throwCannotReachException((Exception)((Object)e));
        }
        this.username = username;
        if (this.isShellMode()) {
            try {
                this.session.allocateDefaultPTY();
                this.shell = this.session.startShell();
            }
            catch (TransportException e) {
                this.throwCannotReachException((Exception)((Object)e));
            }
            catch (net.schmizz.sshj.connection.ConnectionException e) {
                this.throwCannotReachException((Exception)((Object)e));
            }
            int bufSize = this.shell.getLocalMaxPacketSize();
            this.writerStream = this.shell.getOutputStream();
            this.callbackStream = new CallbackOutputStream(this, bufSize);
            new StreamCopier(this.shell.getInputStream(), this.callbackStream).bufSize(bufSize).spawn(String.format("SSH reader thread for user %s", this.username));
            new StreamCopier(this.shell.getErrorStream(), this.callbackStream).bufSize(bufSize).spawn(String.format("SSH error thread for user %s", this.username));
        }
    }

    public void disconnect() {
        if (this.shell != null) {
            try {
                this.shell.close();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error found closing shell for user %s", this.username), (Throwable)e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error found closing session for user %s", this.username), (Throwable)e);
            }
        }
        if (this.client != null) {
            try {
                this.client.disconnect();
            }
            catch (IOException e) {
                logger.error((Object)String.format("Error found closing client for user %s", this.username), (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected() && this.client.isAuthenticated() && this.session != null && this.session.isOpen() && (this.shell == null || this.shell.isOpen());
    }

    public String getConnectionIdentifier() {
        return this.username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(String content, boolean breakLine) throws IOException {
        String string = content = breakLine ? content + "\n" : content;
        if (this.shellMode) {
            this.writerStream.write(content.getBytes());
            this.writerStream.flush();
            return;
        }
        Session.Command cmd = null;
        try {
            cmd = this.session.exec(content);
            this.doCallback(IOUtils.readFully((InputStream)cmd.getInputStream()).toString());
        }
        catch (Throwable throwable) {
            try {
                if (cmd == null) throw throwable;
                cmd.close();
                throw throwable;
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error found closing command %s for user %s", content, this.username), (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (cmd == null) return;
            cmd.close();
            return;
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error found closing command %s for user %s", content, this.username), (Throwable)e);
            return;
        }
    }

    protected void doCallback(String response) {
        if (!StringUtils.isEmpty((String)response)) {
            HashMap<String, String> inbound = new HashMap<String, String>();
            inbound.put(SSH_CALLBACK_USER, this.username);
            DefaultMuleMessage message = new DefaultMuleMessage((Object)response, inbound, null, null, this.muleContext);
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)this.callbackFlow);
            try {
                this.callbackFlow.process((MuleEvent)event);
            }
            catch (MuleException e) {
                logger.error((Object)"Error invoking callback flow", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    private void throwCannotReachException(Exception e) throws ConnectionException {
        throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e.getMessage(), e.getMessage());
    }

    public boolean isShellMode() {
        return this.shellMode;
    }

    public void setShellMode(boolean shellMode) {
        this.shellMode = shellMode;
    }

    public String getCallbackFlowName() {
        return this.callbackFlowName;
    }

    public void setCallbackFlowName(String callbackFlowName) {
        this.callbackFlowName = callbackFlowName;
    }

    public Integer getReceiverBufferSize() {
        return this.receiverBufferSize;
    }

    public void setReceiverBufferSize(Integer receiverBufferSize) {
        if (receiverBufferSize < 1) {
            throw new IllegalArgumentException("ReceiverBufferSize must be greater or equal than 1");
        }
        this.receiverBufferSize = receiverBufferSize;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    public boolean isDisableKnownHostsVerification() {
        return this.disableKnownHostsVerification;
    }

    public void setDisableKnownHostsVerification(boolean disableKnownHostsVerification) {
        this.disableKnownHostsVerification = disableKnownHostsVerification;
    }
}

