
package org.mule.modules.ssh.multiplexer.connectivity;

import javax.annotation.Generated;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultTestResult;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.modules.ssh.multiplexer.SshConnector;
import org.mule.modules.ssh.multiplexer.pooling.DevkitGenericKeyedObjectPool;
import org.mule.modules.ssh.multiplexer.processors.ConnectivityProcessor;


/**
 * A {@code SshConnectorConnectionManager} is a wrapper around {@link SshConnector } that adds connection management capabilities to the pojo.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2015-07-30T01:01:02-03:00", comments = "Build UNNAMED.2405.44720b7")
public class SshConnectorConnectionManager
    extends ExpressionEvaluatorSupport
    implements MetadataAware, MuleContextAware, ProcessAdapter<SshConnectorAdapter> , Capabilities, Disposable, Initialisable, Testable, ConnectionManagementConnectionManager<SshConnectorConnectionKey, SshConnectorAdapter, Object>
{

    /**
     * 
     */
    private String username;
    /**
     * 
     */
    private String password;
    /**
     * 
     */
    private String privateKeyFile;
    /**
     * 
     */
    private String host;
    /**
     * 
     */
    private Integer port;
    private Integer timeout;
    private String callbackFlowName;
    private boolean shellMode;
    private boolean disableKnownHostsVerification;
    private String knownHostsFile;
    private Integer receiverBufferSize;
    /**
     * Mule Context
     * 
     */
    protected MuleContext muleContext;
    /**
     * Connector Pool
     * 
     */
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private final static String MODULE_NAME = "SSH";
    private final static String MODULE_VERSION = "1.2.2";
    private final static String DEVKIT_VERSION = "3.6.1";
    private final static String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private final static String MIN_MULE_VERSION = "3.5.0";

    /**
     * Sets port
     * 
     * @param value Value to set
     */
    public void setPort(Integer value) {
        this.port = value;
    }

    /**
     * Retrieves port
     * 
     */
    public Integer getPort() {
        return this.port;
    }

    /**
     * Sets privateKeyFile
     * 
     * @param value Value to set
     */
    public void setPrivateKeyFile(String value) {
        this.privateKeyFile = value;
    }

    /**
     * Retrieves privateKeyFile
     * 
     */
    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    /**
     * Sets username
     * 
     * @param value Value to set
     */
    public void setUsername(String value) {
        this.username = value;
    }

    /**
     * Retrieves username
     * 
     */
    public String getUsername() {
        return this.username;
    }

    /**
     * Sets host
     * 
     * @param value Value to set
     */
    public void setHost(String value) {
        this.host = value;
    }

    /**
     * Retrieves host
     * 
     */
    public String getHost() {
        return this.host;
    }

    /**
     * Sets password
     * 
     * @param value Value to set
     */
    public void setPassword(String value) {
        this.password = value;
    }

    /**
     * Retrieves password
     * 
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * Sets timeout
     * 
     * @param value Value to set
     */
    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    /**
     * Retrieves timeout
     * 
     */
    public Integer getTimeout() {
        return this.timeout;
    }

    /**
     * Sets callbackFlowName
     * 
     * @param value Value to set
     */
    public void setCallbackFlowName(String value) {
        this.callbackFlowName = value;
    }

    /**
     * Retrieves callbackFlowName
     * 
     */
    public String getCallbackFlowName() {
        return this.callbackFlowName;
    }

    /**
     * Sets shellMode
     * 
     * @param value Value to set
     */
    public void setShellMode(boolean value) {
        this.shellMode = value;
    }

    /**
     * Retrieves shellMode
     * 
     */
    public boolean getShellMode() {
        return this.shellMode;
    }

    /**
     * Sets disableKnownHostsVerification
     * 
     * @param value Value to set
     */
    public void setDisableKnownHostsVerification(boolean value) {
        this.disableKnownHostsVerification = value;
    }

    /**
     * Retrieves disableKnownHostsVerification
     * 
     */
    public boolean getDisableKnownHostsVerification() {
        return this.disableKnownHostsVerification;
    }

    /**
     * Sets knownHostsFile
     * 
     * @param value Value to set
     */
    public void setKnownHostsFile(String value) {
        this.knownHostsFile = value;
    }

    /**
     * Retrieves knownHostsFile
     * 
     */
    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    /**
     * Sets receiverBufferSize
     * 
     * @param value Value to set
     */
    public void setReceiverBufferSize(Integer value) {
        this.receiverBufferSize = value;
    }

    /**
     * Retrieves receiverBufferSize
     * 
     */
    public Integer getReceiverBufferSize() {
        return this.receiverBufferSize;
    }

    /**
     * Sets muleContext
     * 
     * @param value Value to set
     */
    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    /**
     * Retrieves muleContext
     * 
     */
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /**
     * Sets poolingProfile
     * 
     * @param value Value to set
     */
    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    /**
     * Retrieves poolingProfile
     * 
     */
    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    /**
     * Sets retryPolicyTemplate
     * 
     * @param value Value to set
     */
    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    /**
     * Retrieves retryPolicyTemplate
     * 
     */
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), poolingProfile);
        if (retryPolicyTemplate == null) {
            retryPolicyTemplate = muleContext.getRegistry().lookupObject(MuleProperties.OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE);
        }
    }

    @Override
    public void dispose() {
        try {
            connectionPool.close();
        } catch (Exception e) {
        }
    }

    public SshConnectorAdapter acquireConnection(SshConnectorConnectionKey key)
        throws Exception
    {
        return ((SshConnectorAdapter) connectionPool.borrowObject(key));
    }

    public void releaseConnection(SshConnectorConnectionKey key, SshConnectorAdapter connection)
        throws Exception
    {
        connectionPool.returnObject(key, connection);
    }

    public void destroyConnection(SshConnectorConnectionKey key, SshConnectorAdapter connection)
        throws Exception
    {
        connectionPool.invalidateObject(key, connection);
    }

    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

    @Override
    public<P >ProcessTemplate<P, SshConnectorAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, muleContext);
    }

    @Override
    public SshConnectorConnectionKey getDefaultConnectionKey() {
        return new SshConnectorConnectionKey(getUsername(), getPassword(), getPrivateKeyFile(), getHost(), getPort());
    }

    @Override
    public SshConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event)
        throws Exception
    {
        if (event!= null) {
            final String _transformedUsername = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("username").getGenericType(), null, getUsername()));
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            final String _transformedPassword = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("password").getGenericType(), null, getPassword()));
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            final String _transformedPrivateKeyFile = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("privateKeyFile").getGenericType(), null, getPrivateKeyFile()));
            final String _transformedHost = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("host").getGenericType(), null, getHost()));
            if (_transformedHost == null) {
                throw new UnableToAcquireConnectionException("Parameter host in method connect can't be null because is not @Optional");
            }
            final Integer _transformedPort = ((Integer) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("port").getGenericType(), null, getPort()));
            if (_transformedPort == null) {
                throw new UnableToAcquireConnectionException("Parameter port in method connect can't be null because is not @Optional");
            }
            return new SshConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedPrivateKeyFile, _transformedHost, _transformedPort);
        }
        return getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public SshConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        if (hasConnectionKeysOverride(messageProcessor)) {
            ConnectivityProcessor connectivityProcessor = ((ConnectivityProcessor) messageProcessor);
            final String _transformedUsername = ((String) evaluateAndTransform(muleContext, event, connectivityProcessor.typeFor("_usernameType"), null, connectivityProcessor.getUsername()));
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            final String _transformedPassword = ((String) evaluateAndTransform(muleContext, event, connectivityProcessor.typeFor("_passwordType"), null, connectivityProcessor.getPassword()));
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            final String _transformedPrivateKeyFile = ((String) evaluateAndTransform(muleContext, event, connectivityProcessor.typeFor("_privateKeyFileType"), null, connectivityProcessor.getPrivateKeyFile()));
            final String _transformedHost = ((String) evaluateAndTransform(muleContext, event, connectivityProcessor.typeFor("_hostType"), null, connectivityProcessor.getHost()));
            if (_transformedHost == null) {
                throw new UnableToAcquireConnectionException("Parameter host in method connect can't be null because is not @Optional");
            }
            final Integer _transformedPort = ((Integer) evaluateAndTransform(muleContext, event, connectivityProcessor.typeFor("_portType"), null, connectivityProcessor.getPort()));
            if (_transformedPort == null) {
                throw new UnableToAcquireConnectionException("Parameter port in method connect can't be null because is not @Optional");
            }
            return new SshConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedPrivateKeyFile, _transformedHost, _transformedPort);
        } else {
            return getEvaluatedConnectionKey(event);
        }
    }

    /**
     * Validates that the current message processor has changed any of its connection parameters at processor level. If so, a new SshConnectorConnectionKey must be generated
     * 
     * @param messageProcessor
     *     the message processor to test against the keys
     * @return
     *     true if any of the parameters in @Connect method annotated with @ConnectionKey was override in the XML, false otherwise  
     */
    private Boolean hasConnectionKeysOverride(MessageProcessor messageProcessor) {
        if ((messageProcessor == null)||(!(messageProcessor instanceof ConnectivityProcessor))) {
            return false;
        }
        ConnectivityProcessor connectivityProcessor = ((ConnectivityProcessor) messageProcessor);
        if (connectivityProcessor.getUsername()!= null) {
            return true;
        }
        return false;
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        SshConnectorAdapter connector = new SshConnectorAdapter();
        connector.setShellMode(getShellMode());
        connector.setTimeout(getTimeout());
        connector.setDisableKnownHostsVerification(getDisableKnownHostsVerification());
        connector.setReceiverBufferSize(getReceiverBufferSize());
        connector.setCallbackFlowName(getCallbackFlowName());
        connector.setKnownHostsFile(getKnownHostsFile());
        return connector;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<Object, SshConnectorConnectionKey> connection) {
        return ((ConnectionManagementConnectorAdapter) connection);
    }

    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        return ((ConnectionManagementConnectionAdapter) adapter);
    }

    public TestResult test() {
        SshConnectorAdapter connection = null;
        DefaultTestResult result;
        SshConnectorConnectionKey key = getDefaultConnectionKey();
        try {
            connection = acquireConnection(key);
            result = new DefaultTestResult(org.mule.common.Result.Status.SUCCESS);
        } catch (Exception e) {
            try {
                destroyConnection(key, connection);
            } catch (Exception ie) {
            }
            result = ((DefaultTestResult) ConnectivityTestingErrorHandler.buildFailureTestResult(e));
        } finally {
            if (connection!= null) {
                try {
                    releaseConnection(key, connection);
                } catch (Exception ie) {
                }
            }
        }
        return result;
    }

}
