/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */
package org.mule.modules.ssh.multiplexer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Factory.Named;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.Session.Command;
import net.schmizz.sshj.connection.channel.direct.Session.Shell;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.signature.SignatureDSA;
import net.schmizz.sshj.signature.SignatureECDSA;
import net.schmizz.sshj.signature.SignatureRSA;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.kex.KeyExchange;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile.Factory;
import net.schmizz.sshj.userauth.password.PasswordUtils;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.*;
import org.mule.api.annotations.display.Password;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.context.MuleContextAware;
import org.mule.construct.Flow;

/**
 * Cloud Connector for ssh that is capable to handle multiple session from
 * different users and reusing the session of any given user if he wants to
 * send multiple messages.
 * 
 * Notice that while this connector can handle N sessions for N users, each user can only have
 * 1 active session at a time
 *
 * @author marianogonzalez
 */
@Connector(name="ssh", schemaVersion="1.2.1", friendlyName="SSH",description="SSH connector")
public class SshConnector implements MuleContextAware {
	
	private static final Logger logger = Logger.getLogger(SshConnector.class);
	
	private static final String SSH_CALLBACK_USER = "SSH_CALLBACK_USER";

	private MuleContext muleContext;
	
	/**
	 * message timeout
	 */
	@Configurable
	private Integer timeout;
	
	/**
	 * If not null, a flow with this name will be
	 * fetched from the registry and invoked everytime
	 * data is received from the other end. Keep in mind that SSH
	 * is a full duplex protocol, meaning that you can receive data at any time,
	 * not just as a reply to a message you have sent.
	 */
	@Configurable
	private String callbackFlowName;
	
	/**
	 * if true, the connection will be opened in shell mode, meaning that
	 * the session context will be maintained from the moment it's stablished
	 * until it's closed. If false, then only single commands will be allowed and no
	 * context will be passed from one invocation to the next.
	 */
	@Configurable
	@Default(value="false")
	private boolean shellMode = false;
	
	/**
	 * if true, verification of host fingerprint against the known_hosts file will NOT be
	 * performed.
	 */
	@Configurable
	@Default(value="false")
	private boolean disableKnownHostsVerification = false;
	
	/**
	 * Location of the known_hosts file in OpenSSH format
	 */
	@Configurable
	@Optional
	private String knownHostsFile = "";
	
	/**
	 * The flow that will receive callback invocations
	 */
	private Flow callbackFlow = null;

	/**
	 * The size of the receiver buffer in bytes. Defaults to 8192
	 * and must be greater or equal to 1
	 */
	@Configurable
	@Optional
	private Integer receiverBufferSize = 8192;
	
	/**
	 * SSH Client class
	 */
	private SSHClient client;
	
	/**
	 * the SSH session
	 */
	private Session session;
	
	/**
	 * The stream from wich we write
	 */
	private OutputStream writerStream;
	
	private OutputStream callbackStream;
	
	private Shell shell;
	
	/**
	 * The username of the active user
	 */
	private String username;

	@Start
    public void init() {
		this.callbackFlow = (Flow) this.muleContext.getRegistry().lookupFlowConstruct(this.callbackFlowName);
		
		if (this.callbackFlow == null) {
			throw new IllegalArgumentException("Could not find callback flow with name " + this.callbackFlowName);
		}
    }
    
    
    /**
     * Starts a connection
     * @param username the username for the login
     * @param password the password for the login or passphrase of the private key if privateKeyFile is not empty
     * @param location of the private key if using key-based authentication (provide passphrase through the password argument)
     * @param host the address for the target host
     * @param port TCP port number in which the host is listening
     * @throws ConnectionException if an error occurs connecting
     */
    @Connect
	@TestConnectivity(active=false)
    public void connect(@ConnectionKey String username, @Password String password, @Optional String privateKeyFile, String host, Integer port) throws ConnectionException {

    	//TODO: REFACTOR. Currently, no check is performed on the known_hosts file to determine the appropriate signature
    	//type for the host. The client will only check the first type offered by the server (matching the supported ones 
    	//from the setSignatureFactories options). This causes that if RSA is offered first, host validation will assume RSA signature exists on
    	//the known_hosts file. If an RSA entry is not on the file, but a DSA, it WON'T be validated, failing the known_host validation process.
    	//The workaround is to try connection with 2 clients, one with (RSA, DSA) and the other with (DSA, RSA). The one that succeeds is used 
    	//as the client moving forward.
    	Config configDSAFirst = new DefaultConfig();
    	Config configRSAFirst = new DefaultConfig();
    	
    	configDSAFirst.setSignatureFactories(
			Arrays.<net.schmizz.sshj.common.Factory.Named<Signature>>asList(
    			
    		    new net.schmizz.sshj.common.Factory.Named<Signature>() {

    		        @Override
    		        public Signature create() {
    		            return new SignatureDSA();
    		        }

    		        @Override
    		        public String getName() {
    		            return KeyType.DSA.toString();
    		        }

    		    },
    		    new net.schmizz.sshj.common.Factory.Named<Signature>() {

    		        @Override
    		        public Signature create() {
    		            return new SignatureRSA();
    		        }

    		        @Override
    		        public String getName() {
    		            return KeyType.RSA.toString();
    		        }

    		    }
		    )
	    );
	    
    	configRSAFirst.setSignatureFactories(
			Arrays.<net.schmizz.sshj.common.Factory.Named<Signature>>asList(
    		    	
    		    new net.schmizz.sshj.common.Factory.Named<Signature>() {

    		        @Override
    		        public Signature create() {
    		            return new SignatureRSA();
    		        }

    		        @Override
    		        public String getName() {
    		            return KeyType.RSA.toString();
    		        }

    		    },
    		    new net.schmizz.sshj.common.Factory.Named<Signature>() {

    		        @Override
    		        public Signature create() {
    		            return new SignatureDSA();
    		        }

    		        @Override
    		        public String getName() {
    		            return KeyType.DSA.toString();
    		        }

    		    }
    		)
    	);
    			
    	SSHClient clientRSAFirst = new SSHClient(configRSAFirst);
    	SSHClient clientDSAFirst = new SSHClient(configDSAFirst);
    	
    	try {
    		Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider()); 
    		if (this.disableKnownHostsVerification) {
    			logger.warn("KNOWN HOST VERIFICATION IS DISABLED -- HOST IS NOT AUTHENTICATED");
    			clientRSAFirst.addHostKeyVerifier(new PromiscuousVerifier());
    			clientDSAFirst.addHostKeyVerifier(new PromiscuousVerifier());
    		} else {
	    		if (this.knownHostsFile != null && !this.knownHostsFile.isEmpty()) {
	    			logger.warn("Loading known hosts file from " + this.knownHostsFile);
	    			File knownHosts = new File(this.knownHostsFile);
	    			if (!knownHosts.exists() || !knownHosts.canRead()) {
	    				throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "", "Error loading known hosts: Can't read " + this.knownHostsFile);
	    			}
	    			clientRSAFirst.loadKnownHosts(knownHosts);
	    			clientDSAFirst.loadKnownHosts(knownHosts);
	    		} else {
	    			logger.warn("Loading known hosts file from default locations");
	    			clientRSAFirst.loadKnownHosts();
	    			clientDSAFirst.loadKnownHosts();
	    		}
    		}
    	} catch (IOException e) {
    		throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, e.getMessage(), "Error loading known hosts", e);
    	}
    	
    	
    	if (this.timeout != null) {
    		clientDSAFirst.setTimeout(this.timeout);
    		clientRSAFirst.setTimeout(this.timeout);
    		clientDSAFirst.getTransport().setTimeoutMs(this.timeout);
    		clientRSAFirst.getTransport().setTimeoutMs(this.timeout);
    	}
    	
    	try {
    		clientRSAFirst.connect(host, port);
    		this.client = clientRSAFirst;
    	} catch (TransportException e) {
    		logger.info("RSA signature failed, trying DSA");
    		try {
        		clientDSAFirst.connect(host, port);
        		this.client = clientDSAFirst;
        	} catch (TransportException e2) {
        		logger.info("DSA and RSA signature failed");
        		throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e2.getMessage(), String.format("Could not reach ssh server at %s:%d", host, port), e2);
        	} catch (IOException e3) {
        		throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e3.getMessage(), String.format("Could not reach ssh server at %s:%d", host, port), e3);
        	}
    	} catch (IOException e) {
    		throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e.getMessage(), String.format("Could not reach ssh server at %s:%d", host, port), e);
    	}
    	
    	try {
    		if (privateKeyFile == null || privateKeyFile.isEmpty()) {
    			logger.debug("Private key file location is empty, attempting username/password auth");
    			this.client.authPassword(username, password);
    		} else {
    			logger.debug("Attempting public key auth from file " + privateKeyFile);
    			FileKeyProvider provider = (new PKCS8KeyFile.Factory()).create();
    			provider.init(new File(privateKeyFile), PasswordUtils.createOneOff(password.toCharArray()));
    			this.client.authPublickey(username, provider);
    		}	
			this.session = this.client.startSession();
    	} catch (UserAuthException e) {
    		throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, e.getMessage(), "Could not login", e);
    	} catch (TransportException e) {
    		this.throwCannotReachException(e);
    	} catch (net.schmizz.sshj.connection.ConnectionException e) {
    		this.throwCannotReachException(e);
    	}
    	
    	this.username = username;
    	
    	if (this.isShellMode()) {
    		try {
    			this.session.allocateDefaultPTY();
    			this.shell = this.session.startShell();
    		} catch (TransportException e) {
    			this.throwCannotReachException(e);
    		} catch (net.schmizz.sshj.connection.ConnectionException e) {
    			this.throwCannotReachException(e);
    		}
    		
    		int bufSize = shell.getLocalMaxPacketSize();
    		this.writerStream = shell.getOutputStream();
    		this.callbackStream = new CallbackOutputStream(this, bufSize);
    		
    		new StreamCopier(shell.getInputStream(), this.callbackStream)
					.bufSize(bufSize)
					.spawn(String.format("SSH reader thread for user %s", this.username));
			
			new StreamCopier(shell.getErrorStream(), this.callbackStream)
					.bufSize(bufSize)
					.spawn(String.format("SSH error thread for user %s", this.username));
    	}
    }

    /**
     * Releases the connection
     */
    @Disconnect
    public void disconnect() {
    	if (shell != null) {
    		try {
    			shell.close();
    		} catch (Exception e) {
    			logger.error(String.format("Error found closing shell for user %s", this.username), e);
    		}
    	}
    	
    	if (this.session != null) {
    		try {
    			this.session.close();
    		} catch (Exception e) {
    			logger.error(String.format("Error found closing session for user %s", this.username), e);
    		}
    	}
    	
    	if (this.client != null) {
    		try {
    			this.client.disconnect();
    		} catch (IOException e) {
    			logger.error(String.format("Error found closing client for user %s", this.username), e);
    		}
    	}
    }
    
    /**
     * Returns true if the connection is active
     */
    @ValidateConnection
    public boolean isConnected() {
    	return this.client != null
    			&& this.client.isConnected()
    			&& this.client.isAuthenticated()
    			&& this.session != null
    			&& this.session.isOpen()
    			&& (this.shell != null ? this.shell.isOpen() : true);
    }
    
    /**
     * @return the username of the current connection
     */
    @ConnectionIdentifier
    public String getConnectionIdentifier() {
    	return this.username;
    }

    /**
     * Sends the provided content to the SSH host.
     * When the response is received, a new mule message will be generated
     * and will be sent to the configured callback flow.
     * 
     *  That message will carry the response on the payload and will also include
     *  an inbound property called SSH_CALLBACK_USER that specifies the name of the user for whom
     *  the resopnse was sent.
     *  
     * {@sample.xml ../../../doc/ssh-connector.xml.sample ssh:send}
     * 
     * @param content the content to send
     * @param breakLine if true, then a new line character is added at the end of the conent
     * @throws IOException is there was an error in the line
     */
    @Processor
    public void send(String content, @Optional @Default("false") boolean breakLine) throws IOException {
    	content = breakLine ? content + "\n" : content;
    	
    	if (this.shellMode) {
    		this.writerStream.write(content.getBytes());
    		this.writerStream.flush();
    	} else {
    		Command cmd = null;
    		try {
    			cmd = this.session.exec(content);
    			this.doCallback(IOUtils.readFully(cmd.getInputStream()).toString());
    		} finally {
    			try {
    				if (cmd != null) {
    					cmd.close();
    				}
    			} catch (Exception e) {
    				logger.error(String.format("Error found closing command %s for user %s", content, this.username), e);
    			}
    		}
    	}
    }
    
    /**
     * sends the message to the responseFlow if not null
     * @param message - the message. If null then this method does nothing
     */
    protected void doCallback(String response) {
    	if (!StringUtils.isEmpty(response)) {
    		
    		Map<String, Object> inbound = new HashMap<String, Object>();
    		inbound.put(SSH_CALLBACK_USER, username);
    		
    		MuleMessage message = new DefaultMuleMessage(response, inbound, null, null, this.muleContext);
    		MuleEvent event = new DefaultMuleEvent(message, MessageExchangePattern.REQUEST_RESPONSE, this.callbackFlow);
    		
    		try {
    			this.callbackFlow.process(event);
    		} catch (MuleException e) {
				logger.error("Error invoking callback flow", e);
    			throw new RuntimeException(e);
    		}
    	}
    }
    
	public Integer getTimeout() {
		return timeout;
	}


	public void setTimeout(Integer timeout) {
		this.timeout = timeout;
	}
	
	private void throwCannotReachException(Exception e) throws ConnectionException {
		throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e.getMessage(), e.getMessage());
	}


	/**
	 * @return the shellMode
	 */
	public boolean isShellMode() {
		return shellMode;
	}

	public void setShellMode(boolean shellMode) {
		this.shellMode = shellMode;
	}

	/**
	 * @return the callbackFlowName
	 */
	public String getCallbackFlowName() {
		return callbackFlowName;
	}

	public void setCallbackFlowName(String callbackFlowName) {
		this.callbackFlowName = callbackFlowName;
	}

	public Integer getReceiverBufferSize() {
		return receiverBufferSize;
	}

	public void setReceiverBufferSize(Integer receiverBufferSize) {
		if (receiverBufferSize < 1) {
			throw new IllegalArgumentException("ReceiverBufferSize must be greater or equal than 1");
		}
		this.receiverBufferSize = receiverBufferSize;
	}
	
	@Override
	public void setMuleContext(MuleContext context) {
		this.muleContext = context;
		
	}


	/**
	 * @return the Knwon hosts file
	 */
	public String getKnownHostsFile() {
		return knownHostsFile;
	}


	public void setKnownHostsFile(String knownHostsFile) {
		this.knownHostsFile = knownHostsFile;
	}


	/**
	 * @return True if known hosts verification is disabled
	 */
	public boolean isDisableKnownHostsVerification() {
		return disableKnownHostsVerification;
	}


	public void setDisableKnownHostsVerification(
			boolean disableKnownHostsVerification) {
		this.disableKnownHostsVerification = disableKnownHostsVerification;
	}
	
	
	
	
	
}
