/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ssh.multiplexer.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.ssh.multiplexer.adapters.SshConnectorConnectionIdentifierAdapter;
import org.mule.modules.ssh.multiplexer.connection.ConnectionManager;
import org.mule.modules.ssh.multiplexer.connection.UnableToAcquireConnectionException;
import org.mule.modules.ssh.multiplexer.connection.UnableToReleaseConnectionException;
import org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionKey;
import org.mule.modules.ssh.multiplexer.process.ProcessCallback;
import org.mule.modules.ssh.multiplexer.process.ProcessInterceptor;
import org.mule.modules.ssh.multiplexer.processors.AbstractConnectedProcessor;
import org.mule.modules.ssh.multiplexer.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, SshConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<SshConnectorConnectionKey, SshConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, SshConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, SshConnectorConnectionIdentifierAdapter> next, ConnectionManager<SshConnectorConnectionKey, SshConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, SshConnectorConnectionIdentifierAdapter> processCallback, SshConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedUsername;
        SshConnectorConnectionIdentifierAdapter connection = null;
        SshConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getUsername() != null) {
            _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_usernameType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_passwordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            String _transformedHost = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_hostType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getHost());
            if (_transformedHost == null) {
                throw new UnableToAcquireConnectionException("Parameter host in method connect can't be null because is not @Optional");
            }
            Integer _transformedPort = (Integer)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_portType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPort());
            if (_transformedPort == null) {
                throw new UnableToAcquireConnectionException("Parameter port in method connect can't be null because is not @Optional");
            }
            key = new SshConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedHost, _transformedPort);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedUsername = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedUsername;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, SshConnectorConnectionIdentifierAdapter> processCallback, SshConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

