/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ssh.multiplexer.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.modules.ssh.multiplexer.adapters.SshConnectorConnectionIdentifierAdapter;
import org.mule.modules.ssh.multiplexer.basic.Capabilities;
import org.mule.modules.ssh.multiplexer.basic.Capability;
import org.mule.modules.ssh.multiplexer.basic.MetadataAware;
import org.mule.modules.ssh.multiplexer.connection.ConnectionManager;
import org.mule.modules.ssh.multiplexer.connectivity.ManagedConnectionProcessTemplate;
import org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionFactory;
import org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionKey;
import org.mule.modules.ssh.multiplexer.process.ProcessAdapter;
import org.mule.modules.ssh.multiplexer.process.ProcessTemplate;

public class SshConnectorConnectionManager
implements MuleContextAware,
Initialisable,
Capabilities,
MetadataAware,
ConnectionManager<SshConnectorConnectionKey, SshConnectorConnectionIdentifierAdapter>,
ProcessAdapter<SshConnectorConnectionIdentifierAdapter> {
    private String username;
    private String password;
    private String host;
    private Integer port;
    private Integer timeout;
    private String callbackFlowName;
    private boolean shellMode;
    private Integer receiverBufferSize;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "SSH";
    private static final String MODULE_VERSION = "1.2.1";
    private static final String DEVKIT_VERSION = "3.4.0";
    private static final String DEVKIT_BUILD = "3.4.0.1555.8df15c1";

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setCallbackFlowName(String value) {
        this.callbackFlowName = value;
    }

    public String getCallbackFlowName() {
        return this.callbackFlowName;
    }

    public void setShellMode(boolean value) {
        this.shellMode = value;
    }

    public boolean getShellMode() {
        return this.shellMode;
    }

    public void setReceiverBufferSize(Integer value) {
        this.receiverBufferSize = value;
    }

    public Integer getReceiverBufferSize() {
        return this.receiverBufferSize;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    @Override
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setPort(Integer value) {
        this.port = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new SshConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    @Override
    public SshConnectorConnectionIdentifierAdapter acquireConnection(SshConnectorConnectionKey key) throws Exception {
        return (SshConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(SshConnectorConnectionKey key, SshConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(SshConnectorConnectionKey key, SshConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    @Override
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    @Override
    public <P> ProcessTemplate<P, SshConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public SshConnectorConnectionKey getDefaultConnectionKey() {
        return new SshConnectorConnectionKey(this.getUsername(), this.getPassword(), this.getHost(), this.getPort());
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    @Override
    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    @Override
    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }
}

