/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ssh.multiplexer.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.ssh.multiplexer.adapters.SshConnectorConnectionIdentifierAdapter;
import org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionKey;
import org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(SshConnectorConnectionFactory.class);
    private SshConnectorConnectionManager connectionManager;

    public SshConnectorConnectionFactory(SshConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof SshConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        SshConnectorConnectionIdentifierAdapter connector = new SshConnectorConnectionIdentifierAdapter();
        connector.setTimeout(this.connectionManager.getTimeout());
        connector.setCallbackFlowName(this.connectionManager.getCallbackFlowName());
        connector.setShellMode(this.connectionManager.getShellMode());
        connector.setReceiverBufferSize(this.connectionManager.getReceiverBufferSize());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            connector.setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((SshConnectorConnectionKey)key).getUsername(), ((SshConnectorConnectionKey)key).getPassword(), ((SshConnectorConnectionKey)key).getHost(), ((SshConnectorConnectionKey)key).getPort());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SshConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof SshConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.ssh.multiplexer.adapters.SshConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((SshConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((SshConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((SshConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof SshConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.ssh.multiplexer.adapters.SshConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((SshConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SshConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SshConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((SshConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((SshConnectorConnectionIdentifierAdapter)obj).connect(((SshConnectorConnectionKey)key).getUsername(), ((SshConnectorConnectionKey)key).getPassword(), ((SshConnectorConnectionKey)key).getHost(), ((SshConnectorConnectionKey)key).getPort());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

